<?php
session_start();
include 'config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header("Location: index.php");
    exit;
}

if (!isset($_SESSION['siswa_id'])) {
    die("Data siswa tidak ditemukan, silakan login ulang.");
}

$siswa_id = intval($_SESSION['siswa_id']);
$username = $_SESSION['username'];

// Ambil data siswa
$q = mysqli_query($conn, "SELECT * FROM siswa WHERE id = $siswa_id");
if (!$q) {
    die("Error: " . mysqli_error($conn));
}
$siswa = mysqli_fetch_assoc($q);

// Handle update profile
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_profile'])) {
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $no_wa = mysqli_real_escape_string($conn, $_POST['no_wa']);

    $query = "UPDATE siswa SET nama = '$nama', no_wa = '$no_wa' WHERE id = $siswa_id";
    
    if (mysqli_query($conn, $query)) {
        $success_profile = "Profil berhasil diperbarui!";
        // Update session data
        $_SESSION['username'] = $username;
    } else {
        $error_profile = "Gagal memperbarui profil: " . mysqli_error($conn);
    }
}

// Handle change password
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_password'])) {
    $current_password = mysqli_real_escape_string($conn, $_POST['current_password']);
    $new_password = mysqli_real_escape_string($conn, $_POST['new_password']);
    $confirm_password = mysqli_real_escape_string($conn, $_POST['confirm_password']);

    // Verify current password
    $qUser = mysqli_query($conn, "SELECT password FROM users WHERE username = '$username' AND role = 'siswa'");
    if ($qUser && mysqli_num_rows($qUser) > 0) {
        $user = mysqli_fetch_assoc($qUser);
        
        if (md5($current_password) === $user['password']) {
            if ($new_password === $confirm_password) {
                if (strlen($new_password) >= 6) {
                    $hashed_password = md5($new_password);
                    $query = "UPDATE users SET password = '$hashed_password' WHERE username = '$username' AND role = 'siswa'";
                    
                    if (mysqli_query($conn, $query)) {
                        $success_password = "Password berhasil diubah!";
                    } else {
                        $error_password = "Gagal mengubah password: " . mysqli_error($conn);
                    }
                } else {
                    $error_password = "Password baru minimal 6 karakter!";
                }
            } else {
                $error_password = "Konfirmasi password tidak sesuai!";
            }
        } else {
            $error_password = "Password saat ini salah!";
        }
    } else {
        $error_password = "User tidak ditemukan!";
    }
}
?>

<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Akun Siswa - Sistem Absensi QR</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --success: #10b981;
            --danger: #ef4444;
            --card-bg: #ffffff;
            --card-bg-dark: #374151;
            --text-primary: #1f2937;
            --text-primary-dark: #f9fafb;
            --border-radius: 12px;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }

        .dark {
            --card-bg: var(--card-bg-dark);
            --text-primary: var(--text-primary-dark);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #f8fafc;
            color: var(--text-primary);
            line-height: 1.6;
        }

        .dark body {
            background: #0f172a;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
        }

        .header {
            background: linear-gradient(135deg, #6b7280 0%, #4b5563 100%);
            color: white;
            padding: 2rem;
            border-radius: var(--border-radius);
            margin-bottom: 2rem;
            text-align: center;
        }

        .header h1 {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }

        .card {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            padding: 2rem;
            box-shadow: var(--shadow);
            margin-bottom: 2rem;
        }

        .profile-header {
            display: flex;
            align-items: center;
            gap: 1.5rem;
            margin-bottom: 2rem;
            padding-bottom: 2rem;
            border-bottom: 1px solid #e5e7eb;
        }

        .dark .profile-header {
            border-bottom-color: #4b5563;
        }

        .avatar {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: white;
        }

        .profile-info h2 {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
        }

        .profile-info p {
            color: #6b7280;
            margin-bottom: 0.25rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
        }

        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 8px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
        }

        .btn-danger {
            background: var(--danger);
            color: white;
        }

        .btn-danger:hover {
            background: #dc2626;
        }

        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }

        .alert-success {
            background: #d1fae5;
            color: #059669;
            border: 1px solid #a7f3d0;
        }

        .alert-error {
            background: #fee2e2;
            color: #dc2626;
            border: 1px solid #fecaca;
        }

        .back-btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: #6b7280;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            margin-bottom: 2rem;
            transition: background 0.3s;
        }

        .back-btn:hover {
            background: #4b5563;
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .info-item {
            background: #f8fafc;
            padding: 1rem;
            border-radius: 8px;
            border-left: 4px solid var(--primary);
        }

        .dark .info-item {
            background: #374151;
        }

        .info-label {
            font-size: 0.875rem;
            color: #6b7280;
            margin-bottom: 0.25rem;
        }

        .info-value {
            font-weight: 600;
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="dashboard_siswa.php" class="back-btn">
            <i class="fas fa-arrow-left"></i> Kembali ke Dashboard
        </a>

        <div class="header">
            <h1><i class="fas fa-user-cog"></i> Kelola Akun</h1>
            <p>Kelola informasi akun dan keamanan</p>
        </div>

        <div class="card">
            <div class="profile-header">
                <div class="avatar">
                    <i class="fas fa-user-graduate"></i>
                </div>
                <div class="profile-info">
                    <h2><?php echo htmlspecialchars($siswa['nama']); ?></h2>
                    <p><i class="fas fa-id-card"></i> <?php echo htmlspecialchars($siswa['nis'] ?? '-'); ?></p>
                    <p><i class="fas fa-graduation-cap"></i> <?php echo htmlspecialchars($siswa['kelas']); ?></p>
                </div>
            </div>

            <div class="info-grid">
                <div class="info-item">
                    <div class="info-label">NIS</div>
                    <div class="info-value"><?php echo htmlspecialchars($siswa['nis'] ?? '-'); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">NISN</div>
                    <div class="info-value"><?php echo htmlspecialchars($siswa['nisn'] ?? '-'); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">Kelas</div>
                    <div class="info-value"><?php echo htmlspecialchars($siswa['kelas']); ?></div>
                </div>
                <div class="info-item">
                    <div class="info-label">Status</div>
                    <div class="info-value" style="color: var(--success);">
                        <i class="fas fa-check-circle"></i> <?php echo ucfirst($siswa['status']); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <h2 style="margin-bottom: 1.5rem;"><i class="fas fa-user-edit"></i> Edit Profil</h2>
            
            <?php if (isset($success_profile)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> <?php echo $success_profile; ?>
                </div>
            <?php endif; ?>

            <?php if (isset($error_profile)): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo $error_profile; ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-group">
                    <label for="nama">Nama Lengkap</label>
                    <input type="text" class="form-control" id="nama" name="nama" 
                           value="<?php echo htmlspecialchars($siswa['nama']); ?>" required>
                </div>

                <div class="form-group">
                    <label for="no_wa">Nomor WhatsApp</label>
                    <input type="tel" class="form-control" id="no_wa" name="no_wa" 
                           value="<?php echo htmlspecialchars($siswa['no_wa'] ?? ''); ?>" 
                           placeholder="Contoh: 628123456789">
                </div>

                <button type="submit" name="update_profile" class="btn btn-primary">
                    <i class="fas fa-save"></i> Simpan Perubahan
                </button>
            </form>
        </div>

        <div class="card">
            <h2 style="margin-bottom: 1.5rem;"><i class="fas fa-lock"></i> Ubah Password</h2>
            
            <?php if (isset($success_password)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> <?php echo $success_password; ?>
                </div>
            <?php endif; ?>

            <?php if (isset($error_password)): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo $error_password; ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-group">
                    <label for="current_password">Password Saat Ini</label>
                    <input type="password" class="form-control" id="current_password" name="current_password" required>
                </div>

                <div class="form-group">
                    <label for="new_password">Password Baru</label>
                    <input type="password" class="form-control" id="new_password" name="new_password" 
                           placeholder="Minimal 6 karakter" required>
                </div>

                <div class="form-group">
                    <label for="confirm_password">Konfirmasi Password Baru</label>
                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                </div>

                <button type="submit" name="change_password" class="btn btn-primary">
                    <i class="fas fa-key"></i> Ubah Password
                </button>
            </form>
        </div>
    </div>
</body>
</html>