<?php
session_start();
include 'config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header("Location: index.php");
    exit;
}

if (!isset($_SESSION['siswa_id'])) {
    die("Data siswa tidak ditemukan, silakan login ulang.");
}

$siswa_id = intval($_SESSION['siswa_id']);
$username = $_SESSION['username'];

// Ambil data siswa
$q = mysqli_query($conn, "SELECT nama, kelas FROM siswa WHERE id = $siswa_id");
if (!$q) {
    die("Error: " . mysqli_error($conn));
}
$siswa = mysqli_fetch_assoc($q);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_bimbingan'])) {
    $tanggal = mysqli_real_escape_string($conn, $_POST['tanggal']);
    $topik = mysqli_real_escape_string($conn, $_POST['topik']);
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);
    $created_at = date('Y-m-d H:i:s');

    $query = "INSERT INTO bimbingan_konseling (siswa_id, tanggal, topik, keterangan, status, created_at) 
              VALUES ($siswa_id, '$tanggal', '$topik', '$keterangan', 'pending', '$created_at')";
    
    if (mysqli_query($conn, $query)) {
        $success = "Pengajuan bimbingan berhasil dikirim!";
    } else {
        $error = "Gagal mengajukan bimbingan: " . mysqli_error($conn);
    }
}

// Ambil riwayat bimbingan
$qRiwayat = mysqli_query($conn, "
    SELECT * FROM bimbingan_konseling 
    WHERE siswa_id = $siswa_id 
    ORDER BY created_at DESC
");
$riwayat_bimbingan = [];
if ($qRiwayat) {
    while ($row = mysqli_fetch_assoc($qRiwayat)) {
        $riwayat_bimbingan[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bimbingan Konseling - Sistem Absensi QR</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* CSS sama seperti sebelumnya, tetap dipertahankan */
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --success: #10b981;
            --warning: #f59e0b;
            --card-bg: #ffffff;
            --card-bg-dark: #374151;
            --text-primary: #1f2937;
            --text-primary-dark: #f9fafb;
            --border-radius: 12px;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }

        .dark {
            --card-bg: var(--card-bg-dark);
            --text-primary: var(--text-primary-dark);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #f8fafc;
            color: var(--text-primary);
            line-height: 1.6;
        }

        .dark body {
            background: #0f172a;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }

        .header {
            background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
            color: white;
            padding: 2rem;
            border-radius: var(--border-radius);
            margin-bottom: 2rem;
            text-align: center;
        }

        .header h1 {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }

        .card {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            padding: 2rem;
            box-shadow: var(--shadow);
            margin-bottom: 2rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
        }

        .form-control {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #d1d5db;
            border-radius: 8px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .form-control:focus {
            outline: none;
            border-color: var(--primary);
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: var(--primary-dark);
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }

        .table th,
        .table td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid #e5e7eb;
        }

        .table th {
            background: #f8fafc;
            font-weight: 600;
        }

        .dark .table th {
            background: #374151;
        }

        .status {
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.875rem;
            font-weight: 500;
        }

        .status-pending {
            background: #fef3c7;
            color: #d97706;
        }

        .status-approved {
            background: #d1fae5;
            color: #059669;
        }

        .status-completed {
            background: #dbeafe;
            color: #3b82f6;
        }

        .status-rejected {
            background: #fee2e2;
            color: #dc2626;
        }

        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }

        .alert-success {
            background: #d1fae5;
            color: #059669;
            border: 1px solid #a7f3d0;
        }

        .alert-error {
            background: #fee2e2;
            color: #dc2626;
            border: 1px solid #fecaca;
        }

        .back-btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: #6b7280;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            margin-bottom: 2rem;
            transition: background 0.3s;
        }

        .back-btn:hover {
            background: #4b5563;
        }

        .info-box {
            background: #e0f2fe;
            border: 1px solid #bae6fd;
            border-radius: 8px;
            padding: 1.5rem;
            margin-bottom: 2rem;
        }

        .dark .info-box {
            background: #1e3a8a;
            border-color: #3b82f6;
        }

        .info-box h3 {
            color: #0369a1;
            margin-bottom: 0.5rem;
        }

        .dark .info-box h3 {
            color: #93c5fd;
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="dashboard_siswa.php" class="back-btn">
            <i class="fas fa-arrow-left"></i> Kembali ke Dashboard
        </a>

        <div class="header">
            <h1><i class="fas fa-hands-helping"></i> Bimbingan Konseling</h1>
            <p>Ajukan sesi bimbingan dan konseling dengan guru BK</p>
        </div>

        <div class="info-box">
            <h3><i class="fas fa-lightbulb"></i> Informasi Bimbingan Konseling</h3>
            <p>Layanan bimbingan konseling tersedia untuk membantu Anda dalam berbagai hal seperti:</p>
            <ul style="margin-top: 0.5rem; padding-left: 1.5rem;">
                <li>Masalah akademik dan belajar</li>
                <li>Pengembangan karir dan minat</li>
                <li>Masalah pribadi dan sosial</li>
                <li>Perencanaan masa depan</li>
            </ul>
        </div>

        <?php if (isset($success)): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i> <?php echo $success; ?>
            </div>
        <?php endif; ?>

        <?php if (isset($error)): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <div class="card">
            <h2 style="margin-bottom: 1.5rem;"><i class="fas fa-plus-circle"></i> Ajukan Bimbingan Baru</h2>
            <form method="POST">
                <div class="form-group">
                    <label for="tanggal">Tanggal yang Diinginkan</label>
                    <input type="date" class="form-control" id="tanggal" name="tanggal" required 
                           min="<?php echo date('Y-m-d'); ?>">
                </div>

                <div class="form-group">
                    <label for="topik">Topik Bimbingan</label>
                    <select class="form-control" id="topik" name="topik" required>
                        <option value="">Pilih Topik Bimbingan</option>
                        <option value="Masalah Akademik">Masalah Akademik</option>
                        <option value="Pengembangan Diri">Pengembangan Diri</option>
                        <option value="Konseling Karir">Konseling Karir</option>
                        <option value="Masalah Pribadi">Masalah Pribadi</option>
                        <option value="Masalah Sosial">Masalah Sosial</option>
                        <option value="Lainnya">Lainnya</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="keterangan">Keterangan Detail</label>
                    <textarea class="form-control" id="keterangan" name="keterangan" rows="4" 
                              placeholder="Jelaskan secara detail permasalahan atau topik yang ingin dibahas..." required></textarea>
                </div>

                <button type="submit" name="submit_bimbingan" class="btn btn-primary">
                    <i class="fas fa-paper-plane"></i> Ajukan Bimbingan
                </button>
            </form>
        </div>

        <div class="card">
            <h2 style="margin-bottom: 1.5rem;"><i class="fas fa-history"></i> Riwayat Bimbingan</h2>
            <?php if (empty($riwayat_bimbingan)): ?>
                <p style="text-align: center; color: #6b7280; padding: 2rem;">
                    <i class="fas fa-comments" style="font-size: 3rem; margin-bottom: 1rem; opacity: 0.5;"></i><br>
                    Belum ada pengajuan bimbingan
                </p>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Tanggal</th>
                                <th>Topik</th>
                                <th>Keterangan</th>
                                <th>Status</th>
                                <th>Tanggal Pengajuan</th>
                                <th>Catatan Guru BK</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($riwayat_bimbingan as $bimbingan): ?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($bimbingan['tanggal'])); ?></td>
                                    <td><?php echo htmlspecialchars($bimbingan['topik']); ?></td>
                                    <td><?php echo htmlspecialchars($bimbingan['keterangan']); ?></td>
                                    <td>
                                        <?php 
                                        $status_class = '';
                                        switch($bimbingan['status']) {
                                            case 'pending': $status_class = 'status-pending'; break;
                                            case 'approved': $status_class = 'status-approved'; break;
                                            case 'completed': $status_class = 'status-completed'; break;
                                            case 'rejected': $status_class = 'status-rejected'; break;
                                        }
                                        ?>
                                        <span class="status <?php echo $status_class; ?>">
                                            <?php echo ucfirst($bimbingan['status']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('d/m/Y H:i', strtotime($bimbingan['created_at'])); ?></td>
                                    <td><?php echo htmlspecialchars($bimbingan['catatan_guru'] ?? '-'); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        // Set minimum date to today
        document.getElementById('tanggal').min = new Date().toISOString().split('T')[0];
    </script>
</body>
</html>