<?php
require('fpdf/fpdf.php');
include 'config.php';

$kelas = $_GET['kelas'] ?? '';
$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');

// Dapatkan tanggal hari ini untuk perbandingan
$hariIni = date('d');
$bulanIni = date('m');
$tahunIni = date('Y');
$today = date('Y-m-d');

$jumlahHari = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);

// Ambil siswa hanya yang aktif
$siswaQuery = "SELECT * FROM siswa WHERE status='aktif'";
if ($kelas != '') {
  $siswaQuery .= " AND kelas = '$kelas'";
}
$siswaQuery .= " ORDER BY nama";
$siswaResult = mysqli_query($conn, $siswaQuery);

// Ambil data absensi dari scan
$absensi = [];
$absensiQuery = "SELECT a.*, s.nis, s.nama FROM absensi a 
                 JOIN siswa s ON a.siswa_id = s.id 
                 WHERE MONTH(a.tanggal) = '$bulan' 
                   AND YEAR(a.tanggal) = '$tahun'
                   AND s.status='aktif'";
if ($kelas != '') {
  $absensiQuery .= " AND s.kelas = '$kelas'";
}
$resultAbsensi = mysqli_query($conn, $absensiQuery);

while ($row = mysqli_fetch_assoc($resultAbsensi)) {
  $sid = $row['siswa_id'];
  $tgl = (int)date('j', strtotime($row['tanggal']));
  $absensi[$sid][$tgl] = $row['status'];
}

// Ambil data izin yang disetujui
$izin_data = [];
$izinQuery = "SELECT p.siswa_id, p.tanggal_izin, p.jenis_izin, p.keterangan 
              FROM perizinan p 
              JOIN siswa s ON p.siswa_id = s.id 
              WHERE MONTH(p.tanggal_izin) = '$bulan' 
              AND YEAR(p.tanggal_izin) = '$tahun' 
              AND s.status='aktif'
              AND p.status = 'approved'";
if ($kelas != '') {
  $izinQuery .= " AND s.kelas = '$kelas'";
}
$resultIzin = mysqli_query($conn, $izinQuery);

while ($izin = mysqli_fetch_assoc($resultIzin)) {
  $sid = $izin['siswa_id'];
  $tgl = (int)date('j', strtotime($izin['tanggal_izin']));
  $izin_data[$sid][$tgl] = $izin['jenis_izin'];
}

// Ambil daftar hari libur dari database
$libur = [];
$queryLibur = mysqli_query($conn, "SELECT tanggal FROM hari_libur");
while ($row = mysqli_fetch_assoc($queryLibur)) {
  $libur[] = $row['tanggal'];
}

// Ambil data profil sekolah
$profil = mysqli_fetch_assoc(mysqli_query($conn, "SELECT kepala_sekolah, nip_kepala FROM profil_sekolah LIMIT 1"));

// Ambil data wali kelas
$wali_nama = '....................................';
$wali_nip = '........................';
if ($kelas != '') {
    $qWali = mysqli_query($conn, "SELECT nama_wali, nip_wali FROM wali_kelas WHERE kelas = '$kelas' LIMIT 1");
    if ($w = mysqli_fetch_assoc($qWali)) {
        $wali_nama = $w['nama_wali'];
        $wali_nip = $w['nip_wali'];
    }
}

// Tanggal terakhir bulan ini
$tanggal_terakhir = date("j F Y", strtotime("$tahun-$bulan-" . cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun)));

// --- Cetak PDF ---
$pdf = new FPDF('L','mm','A4');
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,"REKAPITULASI ABSENSI SISWA",0,1,'C');
$pdf->SetFont('Arial','B',12);
$pdf->Cell(0,6,"Bulan: " . date('F Y', strtotime("$tahun-$bulan-01")),0,1,'C');
if ($kelas != '') {
    $pdf->Cell(0,6,"Kelas: $kelas",0,1,'C');
} else {
    $pdf->Cell(0,6,"Kelas: Semua Kelas",0,1,'C');
}
$pdf->Ln(5);

$pdf->SetFont('Arial','',8);

// Header tabel - Baris 1
$pdf->Cell(10,7,'No',1,0,'C');
$pdf->Cell(15,7,'NIS',1,0,'C');
$pdf->Cell(40,7,'Nama Siswa',1,0,'C');

// Kolom tanggal
for ($i = 1; $i <= $jumlahHari; $i++) {
    $pdf->Cell(5,7,$i,1,0,'C');
}

// Kolom rekap
$pdf->Cell(10,7,'H',1,0,'C');
$pdf->Cell(10,7,'S',1,0,'C');
$pdf->Cell(10,7,'I',1,0,'C');
$pdf->Cell(10,7,'A',1,1,'C');

// Isi tabel
$no = 1;
mysqli_data_seek($siswaResult, 0);
while ($siswa = mysqli_fetch_assoc($siswaResult)) {
    $sid = $siswa['id'];
    $pdf->Cell(10,5,$no,1,0,'C');
    
    // Tampilkan NIS lengkap
    $pdf->Cell(15,5,$siswa['nis'],1,0,'C');

    // Batasi nama agar tidak menabrak kolom
    $nama = $siswa['nama'];
    $maxChar = 25;
    if (strlen($nama) > $maxChar) {
        $nama = substr($nama, 0, $maxChar-3) . '...';
    }
    $pdf->Cell(40,5,$nama,1,0,'L');

    $countH = $countS = $countI = $countA = 0;
    
    for ($i = 1; $i <= $jumlahHari; $i++) {
        $tanggal = "$tahun-" . str_pad($bulan, 2, '0', STR_PAD_LEFT) . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
        $day = date('w', strtotime($tanggal));
        $isLibur = in_array($tanggal, $libur);
        
        // Tentukan apakah hari ini adalah hari mendatang
        $isHariMendatang = false;
        if ($tahun == $tahunIni && $bulan == $bulanIni && $i > $hariIni) {
            $isHariMendatang = true;
        } elseif ($tahun == $tahunIni && $bulan > $bulanIni) {
            $isHariMendatang = true;
        } elseif ($tahun > $tahunIni) {
            $isHariMendatang = true;
        }
        
        // LOGIKA SINKRONISASI: Prioritaskan izin yang disetujui, lalu absensi dari scan
        $status = '';
        
        // 1. Cek apakah ada izin yang disetujui untuk tanggal ini
        if (isset($izin_data[$sid][$i])) {
            $jenis_izin = $izin_data[$sid][$i];
            if ($jenis_izin == 'Sakit') {
                $status = 'S';
                $countS++;
            } else {
                $status = 'I';
                $countI++;
            }
        }
        // 2. Cek apakah ada absensi dari scan untuk tanggal ini
        elseif (isset($absensi[$sid][$i])) {
            $status = $absensi[$sid][$i];
            if ($status == 'H') $countH++;
            elseif ($status == 'S') $countS++;
            elseif ($status == 'I') $countI++;
            elseif ($status == 'A') $countA++;
        }
        // 3. Jika tidak ada data sama sekali
        else {
            if ($day == 0 || $isLibur) {
                // Hari Minggu atau libur
                $pdf->SetTextColor(255,0,0); 
                $pdf->Cell(5,5,'L',1,0,'C');
                $pdf->SetTextColor(0,0,0);
            } 
            // Jika hari mendatang, kosongkan
            elseif ($isHariMendatang) {
                $pdf->Cell(5,5,'',1,0,'C');
            }
            // Jika hari kerja yang sudah lewat tanpa data absensi = Alpha
            else {
                $pdf->SetTextColor(255,0,0);
                $pdf->Cell(5,5,'A',1,0,'C');
                $pdf->SetTextColor(0,0,0);
                $countA++;
            }
            continue; // Skip ke tanggal berikutnya
        }
        
        // Tampilkan status berdasarkan logika di atas
        if ($status == 'H') {
            $pdf->Cell(5,5,'H',1,0,'C');
        } elseif ($status == 'A') {
            $pdf->SetTextColor(255,0,0);
            $pdf->Cell(5,5,'A',1,0,'C');
            $pdf->SetTextColor(0,0,0);
        } elseif ($status == 'S') {
            $pdf->Cell(5,5,'S',1,0,'C');
        } elseif ($status == 'I') {
            $pdf->Cell(5,5,'I',1,0,'C');
        } else {
            $pdf->Cell(5,5,$status,1,0,'C');
        }
    }
    
    $pdf->Cell(10,5,$countH,1,0,'C');
    $pdf->Cell(10,5,$countS,1,0,'C');
    $pdf->Cell(10,5,$countI,1,0,'C');
    $pdf->Cell(10,5,$countA,1,1,'C');

    $no++;
}

$pdf->Ln(5);

// Keterangan - Perbaikan karakter khusus
$pdf->SetFont('Arial','',8);
$pdf->Cell(0,4,'Keterangan:',0,1,'L');
$pdf->Cell(0,4,'H : Hadir, S : Sakit, I : Izin, A : Alpha, L : Libur/Minggu',0,1,'L');
$pdf->Cell(0,4,'* Sinkron dengan data scan QR dan izin yang disetujui',0,1,'L');
$pdf->Ln(3);

// Tanda tangan - Perbaikan format
$pdf->SetFont('Arial','',10);

// Membuat tabel untuk tanda tangan
$pdf->Cell(95,5,'Mengetahui,',0,0,'L');
$pdf->Cell(95,5,$tanggal_terakhir,0,1,'R');
$pdf->Ln(8);

$pdf->Cell(95,5,'Kepala Sekolah',0,0,'L');
$pdf->Cell(95,5,'Wali Kelas '.($kelas != '' ? $kelas : '(Semua Kelas)'),0,1,'R');
$pdf->Ln(15);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(95,5,$profil['kepala_sekolah'] ?? '....................................',0,0,'L');
$pdf->Cell(95,5,$wali_nama,0,1,'R');

$pdf->SetFont('Arial','',10);
$pdf->Cell(95,5,'NIP. '.($profil['nip_kepala'] ?? '........................'),0,0,'L');
$pdf->Cell(95,5,'NIP. '.$wali_nip,0,1,'R');

$pdf->Output();
?>