<?php
session_start();
if (!isset($_SESSION['username']) || !in_array($_SESSION['role'], ['admin', 'guru'])) {
    header("Location: index.php");
    exit;
}

include 'config.php';
require 'fpdf/fpdf.php';

// Ambil data profil sekolah
$profil = mysqli_fetch_assoc(mysqli_query($conn, "SELECT logo, nama_sekolah, alamat FROM profil_sekolah LIMIT 1"));
$logo_path = null;
if ($profil && !empty($profil['logo'])) {
    $logo_path = __DIR__ . '/uploads/' . $profil['logo'];
}
$nama_sekolah = $profil['nama_sekolah'] ?? 'MTS NURUL HIDAYAH BLADO KULON';
$alamat_sekolah = $profil['alamat'] ?? 'DUSUN GRINTINGAN DESA BLADO KULON TEGALSIWALAN';

// Ambil data guru urutkan berdasarkan nama
$result = mysqli_query($conn, "SELECT * FROM guru WHERE status = 'aktif' ORDER BY nama ASC");

class PDF extends FPDF
{
    public $logo_path;
    public $nama_sekolah;
    public $alamat_sekolah;

    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->SetTextColor(100, 100, 100);
        $this->Cell(0, 10, 'Dicetak pada: ' . date('d/m/Y H:i') . ' | Viralytics_Shop', 0, 0, 'C');
    }
    
    // Function untuk menambahkan image dari URL
    function ImageFromUrl($url, $x, $y, $w, $h)
    {
        // Download gambar dari URL
        $imageContent = @file_get_contents($url);
        if ($imageContent === false) {
            return false;
        }
        
        // Simpan sementara
        $tempFile = tempnam(sys_get_temp_dir(), 'qr');
        file_put_contents($tempFile, $imageContent);
        
        // Tambahkan gambar ke PDF
        $this->Image($tempFile, $x, $y, $w, $h);
        
        // Hapus file temporary
        unlink($tempFile);
        
        return true;
    }
}

$pdf = new PDF('P', 'mm', 'A4');
$pdf->logo_path = $logo_path;
$pdf->nama_sekolah = $nama_sekolah;
$pdf->alamat_sekolah = $alamat_sekolah;
$pdf->SetAutoPageBreak(false);

$card_width = 95;
$card_height = 70; // Tinggi kartu ditambah untuk barcode lebih besar
$margin_x = 7;
$margin_y = 10;
$spacing_x = 5;
$spacing_y = 5;

$x = $margin_x;
$y = $margin_y;
$count = 0;

while ($data = mysqli_fetch_assoc($result)) {
    if ($count % 6 == 0) {
        $pdf->AddPage();
        $x = $margin_x;
        $y = $margin_y;
    }

    // Bingkai kartu
    $pdf->Rect($x, $y, $card_width, $card_height);

    // Logo sekolah
    if ($logo_path && file_exists($logo_path)) {
        $pdf->Image($logo_path, $x + 2, $y + 2, 12, 12);
    }

    // Judul + Nama sekolah - seperti pada kartu siswa
    $pdf->SetXY($x + 16, $y + 2);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->Cell(0, 5, 'Kartu Identitas Guru', 0, 1);

    $pdf->SetX($x + 16);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->Cell(0, 4, $nama_sekolah, 0, 1);

    $pdf->SetX($x + 16);
    $pdf->SetFont('Arial', '', 7);
    $pdf->MultiCell(0, 3, $alamat_sekolah);

    // Garis pemisah
    $pdf->Line($x + 2, $y + 16, $x + $card_width - 2, $y + 16);

    // Data guru (mulai dari Y+18)
    $pdf->SetXY($x + 5, $y + 18);

    // Nama (tebal seperti pada kartu siswa)
    $pdf->SetFont('Arial', 'B', 9);
    $pdf->Cell(50, 5, 'Nama: ' . $data['nama'], 0, 1);

    // Data lainnya
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetX($x + 5);
    $pdf->Cell(50, 4, 'NIP : ' . $data['nip'], 0, 1);

    // Mapel (jika ada di database)
    if (isset($data['mapel']) && !empty($data['mapel'])) {
        $pdf->SetX($x + 5);
        $pdf->Cell(50, 4, 'Mapel: ' . $data['mapel'], 0, 1);
    }

    // WhatsApp (jika ada di database)
    if (isset($data['no_wa']) && !empty($data['no_wa'])) {
        $pdf->SetX($x + 5);
        $pdf->Cell(50, 4, 'WhatsApp: ' . $data['no_wa'], 0, 1);
    }

    // QR Code untuk guru - menggunakan data NIP
    $qr_data = $data['nip']; // Data yang akan diencode dalam QR code
    
    // Cek jika QR code sudah ada di folder assets
    $qr_file = "assets/qr_guru/" . $data['nip'] . ".png";
    
    // Ukuran barcode lebih besar (35x35 mm)
    $qr_size = 35;
    $qr_x = $x + $card_width - $qr_size - 2;
    $qr_y = $y + 18;
    
    if (file_exists($qr_file)) {
        // Jika file QR code sudah ada, gunakan yang sudah ada
        $pdf->Image($qr_file, $qr_x, $qr_y, $qr_size, $qr_size);
    } else {
        // Jika tidak ada, generate menggunakan Google Charts API dengan ukuran lebih besar
        $qr_url = "https://chart.googleapis.com/chart?cht=qr&chs=300x300&chl=" . urlencode($qr_data);
        
        // Tampilkan QR code (gunakan method baru untuk handle URL)
        $qr_success = $pdf->ImageFromUrl($qr_url, $qr_x, $qr_y, $qr_size, $qr_size);
        
        // Jika gagal load QR code, tampilkan placeholder
        if (!$qr_success) {
            $pdf->SetXY($qr_x, $qr_y + $qr_size/2 - 5);
            $pdf->SetFont('Arial', '', 6);
            $pdf->Cell($qr_size, 5, 'QR Code', 1, 0, 'C');
        }
    }

    // Tambahkan teks "Scan QR Code" di bawah barcode
    $pdf->SetXY($qr_x, $qr_y + $qr_size + 1);
    $pdf->SetFont('Arial', '', 6);
    $pdf->Cell($qr_size, 3, 'Scan QR Code', 0, 0, 'C');

    // Posisi kartu berikutnya
    if ($x + $card_width + $spacing_x > 210 - $margin_x) {
        $x = $margin_x;
        $y += $card_height + $spacing_y;
    } else {
        $x += $card_width + $spacing_x;
    }

    $count++;
}

$pdf->Output('I', 'kartu_identitas_guru.pdf');