<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: index.php");
    exit;
}

// Koneksi database
require_once 'config.php';

// Fungsi untuk mendapatkan statistik
function getStatistik($conn) {
    $statistik = [
        'total_siswa' => 0,
        'total_guru' => 0,
        'total_kelas' => 0,
        'kehadiran_hari_ini' => 0,
        'total_hadir' => 0
    ];

    if (!$conn) {
        return $statistik;
    }

    try {
        // Total siswa
        $query = "SELECT COUNT(*) as total FROM siswa WHERE status = 'Aktif'";
        $result = mysqli_query($conn, $query);
        if ($result && $row = mysqli_fetch_assoc($result)) {
            $statistik['total_siswa'] = $row['total'];
        }

        // Total guru
        $query = "SELECT COUNT(*) as total FROM guru WHERE status = 'Aktif'";
        $result = mysqli_query($conn, $query);
        if ($result && $row = mysqli_fetch_assoc($result)) {
            $statistik['total_guru'] = $row['total'];
        }

        // Total kelas
        $query = "SELECT COUNT(DISTINCT kelas) as total FROM siswa WHERE kelas IS NOT NULL AND kelas != ''";
        $result = mysqli_query($conn, $query);
        if ($result && $row = mysqli_fetch_assoc($result)) {
            $statistik['total_kelas'] = $row['total'];
        }

        // Kehadiran hari ini
        $hari_ini = date('Y-m-d');
        $query = "SELECT COUNT(*) as total FROM absensi WHERE DATE(tanggal) = '$hari_ini' AND status = 'Hadir'";
        $result = mysqli_query($conn, $query);
        if ($result && $row = mysqli_fetch_assoc($result)) {
            $statistik['total_hadir'] = $row['total'];
            
            // Hitung persentase
            if ($statistik['total_siswa'] > 0) {
                $statistik['kehadiran_hari_ini'] = round(($statistik['total_hadir'] / $statistik['total_siswa']) * 100);
            }
        }

    } catch (Exception $e) {
        error_log("Error getting statistics: " . $e->getMessage());
    }

    return $statistik;
}

// Ambil statistik
$statistik = getStatistik($conn);
?>
<!DOCTYPE html>
<html lang="id" class="dark">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard Admin - Sistem Absensi QR</title>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #6366f1;
      --primary-dark: #4f46e5;
      --primary-light: #8b5cf6;
      --secondary: #ec4899;
      --accent: #f59e0b;
      --success: #10b981;
      --warning: #f59e0b;
      --danger: #ef4444;
      --info: #3b82f6;
      --dark: #1f2937;
      --darker: #111827;
      --light: #f8fafc;
      --gray: #6b7280;
      --gray-light: #e5e7eb;
      --card-bg: #ffffff;
      --card-bg-dark: #374151;
      --text-primary: #1f2937;
      --text-primary-dark: #f9fafb;
      --text-secondary: #6b7280;
      --text-secondary-dark: #d1d5db;
      --border-radius: 16px;
      --shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
      --shadow-hover: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
      --shadow-dark: 0 10px 25px -5px rgba(0, 0, 0, 0.3), 0 8px 10px -6px rgba(0, 0, 0, 0.2);
      --gradient-primary: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
      --gradient-accent: linear-gradient(135deg, #ec4899 0%, #f59e0b 100%);
      --gradient-success: linear-gradient(135deg, #10b981 0%, #059669 100%);
      --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .dark {
      --card-bg: var(--card-bg-dark);
      --text-primary: var(--text-primary-dark);
      --text-secondary: var(--text-secondary-dark);
      --shadow: var(--shadow-dark);
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
      min-height: 100vh;
      color: var(--text-primary);
      line-height: 1.6;
      transition: var(--transition);
    }

    .dark body {
      background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
    }

    /* Header Styles */
    .header {
      background: var(--gradient-primary);
      color: white;
      padding: 1.5rem 2rem;
      box-shadow: var(--shadow);
      position: relative;
      overflow: hidden;
    }

    .header::before {
      content: '';
      position: absolute;
      top: -50%;
      right: -10%;
      width: 300px;
      height: 300px;
      background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
      border-radius: 50%;
    }

    .header-content {
      position: relative;
      z-index: 2;
      max-width: 1400px;
      margin: 0 auto;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .logo-section h1 {
      font-size: 1.75rem;
      font-weight: 700;
      margin-bottom: 0.25rem;
    }

    .logo-section .subtitle {
      font-size: 0.9rem;
      opacity: 0.9;
      font-weight: 400;
    }

    .user-info {
      background: rgba(255, 255, 255, 0.15);
      padding: 0.75rem 1.5rem;
      border-radius: var(--border-radius);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.2);
      display: flex;
      align-items: center;
      gap: 1rem;
    }

    .user-avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.2);
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.2rem;
    }

    .user-details .welcome {
      font-weight: 500;
      margin-bottom: 0.25rem;
    }

    .user-details .role {
      font-size: 0.85rem;
      opacity: 0.8;
    }

    /* Theme Toggle */
    .theme-toggle {
      background: rgba(255, 255, 255, 0.15);
      border: 1px solid rgba(255, 255, 255, 0.2);
      color: white;
      padding: 0.5rem;
      border-radius: 50%;
      cursor: pointer;
      transition: var(--transition);
      backdrop-filter: blur(10px);
    }

    .theme-toggle:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: rotate(45deg);
    }

    /* Notification Bar */
    .notification-bar {
      background: var(--gradient-accent);
      color: white;
      padding: 1rem 0;
      position: relative;
      overflow: hidden;
    }

    .notification-content {
      max-width: 1400px;
      margin: 0 auto;
      padding: 0 2rem;
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 1rem;
    }

    .notification-icon {
      font-size: 1.25rem;
      animation: bounce 2s infinite;
    }

    @keyframes bounce {
      0%, 20%, 50%, 80%, 100% {transform: translateY(0);}
      40% {transform: translateY(-5px);}
      60% {transform: translateY(-3px);}
    }

    .notification-text {
      font-weight: 500;
      text-align: center;
      font-size: 0.95rem;
    }

    /* Main Content */
    .dashboard-container {
      max-width: 1400px;
      margin: 0 auto;
      padding: 2rem;
    }

    .section-title {
      font-size: 1.5rem;
      font-weight: 600;
      color: var(--text-primary);
      margin-bottom: 1.5rem;
      text-align: center;
      position: relative;
    }

    .section-title::after {
      content: '';
      display: block;
      width: 60px;
      height: 3px;
      background: var(--primary);
      margin: 0.5rem auto;
      border-radius: 2px;
    }

    .section-subtitle {
      font-size: 1.2rem;
      font-weight: 600;
      color: var(--text-primary);
      margin: 2rem 0 1rem;
      padding-left: 0.5rem;
      border-left: 4px solid var(--primary);
    }

    /* Stats Grid */
    .stats-grid {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
      gap: 1.5rem;
      margin-bottom: 3rem;
    }

    .stat-card {
      background: var(--card-bg);
      border-radius: var(--border-radius);
      padding: 2rem 1.5rem;
      box-shadow: var(--shadow);
      transition: var(--transition);
      border: 1px solid rgba(0,0,0,0.05);
      position: relative;
      overflow: hidden;
    }

    .dark .stat-card {
      border: 1px solid rgba(255,255,255,0.1);
    }

    .stat-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 4px;
      background: var(--card-color, var(--primary));
    }

    .stat-card:hover {
      transform: translateY(-8px);
      box-shadow: var(--shadow-hover);
    }

    .stat-header {
      display: flex;
      align-items: center;
      justify-content: space-between;
      margin-bottom: 1rem;
    }

    .stat-icon {
      width: 60px;
      height: 60px;
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.75rem;
      color: white;
      background: var(--card-color, var(--primary));
    }

    .stat-trend {
      font-size: 0.875rem;
      font-weight: 600;
      padding: 0.25rem 0.5rem;
      border-radius: 20px;
      background: rgba(16, 185, 129, 0.1);
      color: var(--success);
    }

    .stat-content {
      text-align: center;
    }

    .stat-number {
      font-size: 2.5rem;
      font-weight: 700;
      color: var(--text-primary);
      margin-bottom: 0.5rem;
      line-height: 1;
    }

    .stat-label {
      font-size: 0.9rem;
      color: var(--text-secondary);
      font-weight: 500;
    }

    .stat-subtext {
      font-size: 0.8rem;
      color: var(--text-secondary);
      margin-top: 0.5rem;
    }

    /* Menu Grid */
    .menu-grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
      gap: 1.5rem;
      margin-bottom: 2rem;
    }

    .menu-card {
      background: var(--card-bg);
      border-radius: var(--border-radius);
      box-shadow: var(--shadow);
      transition: var(--transition);
      overflow: hidden;
      border: 1px solid rgba(0,0,0,0.05);
      position: relative;
    }

    .dark .menu-card {
      border: 1px solid rgba(255,255,255,0.1);
    }

    .menu-card:hover {
      transform: translateY(-8px) scale(1.02);
      box-shadow: var(--shadow-hover);
    }

    .card-header {
      padding: 1.5rem 1.5rem 1rem;
      display: flex;
      align-items: center;
      gap: 1rem;
    }

    .card-icon {
      width: 50px;
      height: 50px;
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.5rem;
      color: white;
      background: var(--card-color, var(--primary));
      flex-shrink: 0;
    }

    .card-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: var(--text-primary);
      margin-bottom: 0.25rem;
    }

    .card-content {
      padding: 0 1.5rem 1.5rem;
    }

    .card-desc {
      font-size: 0.875rem;
      color: var(--text-secondary);
      line-height: 1.5;
      margin-bottom: 1rem;
    }

    .card-button {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 0.5rem;
      width: 100%;
      padding: 0.75rem 1rem;
      background: var(--card-color, var(--primary));
      color: white;
      text-decoration: none;
      border-radius: 10px;
      font-weight: 500;
      font-size: 0.9rem;
      transition: var(--transition);
      border: none;
      cursor: pointer;
    }

    .card-button:hover {
      background: var(--card-dark, var(--primary-dark));
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    }

    /* Footer */
    .footer {
      background: var(--dark);
      color: white;
      text-align: center;
      padding: 1.5rem;
      margin-top: 3rem;
    }

    .footer-content {
      max-width: 1400px;
      margin: 0 auto;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .version {
      font-size: 0.875rem;
      opacity: 0.8;
    }

    .footer-links {
      display: flex;
      gap: 1rem;
    }

    .footer-links a {
      color: white;
      text-decoration: none;
      opacity: 0.8;
      transition: var(--transition);
    }

    .footer-links a:hover {
      opacity: 1;
    }

    /* Responsive Design */
    @media (max-width: 1024px) {
      .menu-grid {
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
      }
    }

    @media (max-width: 768px) {
      .header-content {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
      }

      .user-info {
        width: 100%;
        max-width: 300px;
      }

      .dashboard-container {
        padding: 1.5rem;
      }

      .menu-grid {
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 1rem;
      }

      .stats-grid {
        grid-template-columns: repeat(2, 1fr);
      }

      .footer-content {
        flex-direction: column;
        gap: 1rem;
      }
    }

    @media (max-width: 480px) {
      .header {
        padding: 1rem;
      }

      .dashboard-container {
        padding: 1rem;
      }

      .menu-grid {
        grid-template-columns: 1fr;
      }

      .stats-grid {
        grid-template-columns: 1fr;
      }

      .card-header {
        padding: 1rem 1rem 0.5rem;
      }

      .card-content {
        padding: 0 1rem 1rem;
      }

      .notification-text {
        font-size: 0.85rem;
      }
    }

    /* Loading Animation */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .fade-in-up {
      animation: fadeInUp 0.6s ease-out;
    }
  </style>
</head>
<body>
  <!-- Header -->
  <header class="header">
    <div class="header-content">
      <div class="logo-section">
        <h1>Dashboard Admin</h1>
        <div class="subtitle">Sistem Absensi QR Modern</div>
      </div>
      <div class="user-info">
        <div class="user-avatar">
          <i class="fas fa-user-shield"></i>
        </div>
        <div class="user-details">
          <div class="welcome">Selamat datang, <?php echo htmlspecialchars($_SESSION['username']); ?></div>
          <div class="role"><?php echo htmlspecialchars($_SESSION['role']); ?></div>
        </div>
        <button class="theme-toggle" onclick="toggleTheme()">
          <i class="fas fa-moon"></i>
        </button>
      </div>
    </div>
  </header>

  <!-- Notification Bar -->
  <div class="notification-bar">
    <div class="notification-content">
      <i class="fas fa-bullhorn notification-icon"></i>
      <div class="notification-text">
        فَمَنْ يَّعْمَلْ مِثْقَالَ ذَرَّةٍ خَيْرًا يَّرَهٗۚ ۝٧ - Siapa yang mengerjakan kebaikan seberat zarah, dia akan melihat (balasan)-nya. (Az-Zalzalah:7)
      </div>
    </div>
  </div>

  <!-- Main Content -->
  <div class="dashboard-container">
    <!-- Statistics Section -->
    <div class="stats-grid">
      <div class="stat-card fade-in-up" style="--card-color: #10b981; --card-dark: #059669;">
        <div class="stat-header">
          <div class="stat-icon">
            <i class="fas fa-user-graduate"></i>
          </div>
          <div class="stat-trend">
            <i class="fas fa-chart-line"></i> Active
          </div>
        </div>
        <div class="stat-content">
          <div class="stat-number"><?php echo $statistik['total_siswa']; ?></div>
          <div class="stat-label">Siswa Terdaftar</div>
          <div class="stat-subtext">Status: Aktif</div>
        </div>
      </div>
      
      <div class="stat-card fade-in-up" style="--card-color: #8b5cf6; --card-dark: #7c3aed;">
        <div class="stat-header">
          <div class="stat-icon">
            <i class="fas fa-chalkboard-teacher"></i>
          </div>
          <div class="stat-trend">
            <i class="fas fa-chart-line"></i> Active
          </div>
        </div>
        <div class="stat-content">
          <div class="stat-number"><?php echo $statistik['total_guru']; ?></div>
          <div class="stat-label">Guru Aktif</div>
          <div class="stat-subtext">Pengajar tersertifikasi</div>
        </div>
      </div>
      
      <div class="stat-card fade-in-up" style="--card-color: #f59e0b; --card-dark: #d97706;">
        <div class="stat-header">
          <div class="stat-icon">
            <i class="fas fa-school"></i>
          </div>
          <div class="stat-trend">
            <i class="fas fa-layer-group"></i> Total
          </div>
        </div>
        <div class="stat-content">
          <div class="stat-number"><?php echo $statistik['total_kelas']; ?></div>
          <div class="stat-label">Kelas</div>
          <div class="stat-subtext">Rombongan belajar</div>
        </div>
      </div>
      
      <div class="stat-card fade-in-up" style="--card-color: #ef4444; --card-dark: #dc2626;">
        <div class="stat-header">
          <div class="stat-icon">
            <i class="fas fa-calendar-check"></i>
          </div>
          <div class="stat-trend">
            <i class="fas fa-chart-pie"></i> Today
          </div>
        </div>
        <div class="stat-content">
          <div class="stat-number"><?php echo $statistik['kehadiran_hari_ini']; ?>%</div>
          <div class="stat-label">Kehadiran Hari Ini</div>
          <div class="stat-subtext"><?php echo $statistik['total_hadir']; ?> dari <?php echo $statistik['total_siswa']; ?> siswa</div>
        </div>
      </div>
    </div>

    <!-- Menu Utama -->
    <h2 class="section-title fade-in-up">Menu Utama</h2>
    
    <!-- Kelola Data -->
    <h3 class="section-subtitle fade-in-up">Kelola Data</h3>
    <div class="menu-grid">
      <!-- Data Guru -->
      <div class="menu-card fade-in-up" style="--card-color: #10b981; --card-dark: #059669;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-chalkboard-teacher"></i>
          </div>
          <div>
            <div class="card-title">Data Guru</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Kelola data guru, NIP, mata pelajaran, dan barcode</div>
          <a href="guru.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Data Siswa -->
      <div class="menu-card fade-in-up" style="--card-color: #3b82f6; --card-dark: #2563eb;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-user-graduate"></i>
          </div>
          <div>
            <div class="card-title">Data Siswa</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Kelola data siswa, NIS, NISN, kelas, dan kontak</div>
          <a href="siswa.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Wali Kelas -->
      <div class="menu-card fade-in-up" style="--card-color: #8b5cf6; --card-dark: #7c3aed;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-chalkboard-teacher"></i>
          </div>
          <div>
            <div class="card-title">Wali Kelas</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Kelola data wali kelas dan pembagiannya</div>
          <a href="wali_kelas.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Profil Sekolah -->
      <div class="menu-card fade-in-up" style="--card-color: #6b7280; --card-dark: #4b5563;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-school"></i>
          </div>
          <div>
            <div class="card-title">Profil Sekolah</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Kelola informasi dan identitas sekolah</div>
          <a href="profil.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>
    </div>

    <!-- Absensi & Kehadiran -->
    <h3 class="section-subtitle fade-in-up">Absensi & Kehadiran</h3>
    <div class="menu-grid">
      <!-- SCAN QR + WA API OTOMATIS -->
      <div class="menu-card fade-in-up" style="--card-color: #6366f1; --card-dark: #4f46e5;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-qrcode"></i>
          </div>
          <div>
            <div class="card-title">SCAN QR + WA API OTOMATIS</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Scan QR dengan notifikasi WhatsApp otomatis</div>
          <a href="scan_wa_api.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Isi S/I/A -->
      <div class="menu-card fade-in-up" style="--card-color: #3b82f6; --card-dark: #2563eb;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-clipboard-check"></i>
          </div>
          <div>
            <div class="card-title">Isi S/I/A</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Input data Sakit, Izin, atau Alpha untuk siswa</div>
          <a href="absensi.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Siswa Belum Hadir -->
      <div class="menu-card fade-in-up" style="--card-color: #ef4444; --card-dark: #dc2626;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-user-clock"></i>
          </div>
          <div>
            <div class="card-title">Siswa Belum Hadir</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Lihat daftar siswa yang belum melakukan absensi</div>
          <a href="belum_absensi.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Jam Waktu Absensi -->
      <div class="menu-card fade-in-up" style="--card-color: #8b5cf6; --card-dark: #7c3aed;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-clock"></i>
          </div>
          <div>
            <div class="card-title">Jam Waktu Absensi</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Atur jadwal dan batas waktu absensi</div>
          <a href="jam_absensi.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>
    </div>

    <!-- Rekap & Laporan -->
    <h3 class="section-subtitle fade-in-up">Rekap & Laporan</h3>
    <div class="menu-grid">
      <!-- Rekap Kehadiran Guru -->
      <div class="menu-card fade-in-up" style="--card-color: #f59e0b; --card-dark: #d97706;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-chalkboard-teacher"></i>
          </div>
          <div>
            <div class="card-title">Rekap Kehadiran Guru</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Lihat rekap kehadiran guru per periode</div>
          <a href="rekap_guru.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Rekap Bulanan -->
      <div class="menu-card fade-in-up" style="--card-color: #06b6d4; --card-dark: #0891b2;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-calendar-days"></i>
          </div>
          <div>
            <div class="card-title">Rekap Bulanan</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Lihat rekap absensi per bulan</div>
          <a href="rekap_bulanan.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Rekap Bulanan Guru -->
      <div class="menu-card fade-in-up" style="--card-color: #f59e0b; --card-dark: #d97706;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-chalkboard-teacher"></i>
          </div>
          <div>
            <div class="card-title">Rekap Bulanan Guru</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Lihat rekap kehadiran guru per bulan</div>
          <a href="rekap_bulanan_guru.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Prosentase Kehadiran -->
      <div class="menu-card fade-in-up" style="--card-color: #ec4899; --card-dark: #db2777;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-chart-pie"></i>
          </div>
          <div>
            <div class="card-title">Prosentase Kehadiran</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Statistik persentase kehadiran siswa</div>
          <a href="hadir.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>
    </div>

    <!-- Riwayat & Monitoring -->
    <h3 class="section-subtitle fade-in-up">Riwayat & Monitoring</h3>
    <div class="menu-grid">
      <!-- Riwayat Live Chat -->
      <div class="menu-card fade-in-up" style="--card-color: #25d366; --card-dark: #128c7e;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-comments"></i>
          </div>
          <div>
            <div class="card-title">Riwayat Live Chat</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Monitor percakapan antara wali kelas dan siswa</div>
          <a href="riwayat_chat.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Riwayat Pelanggaran -->
      <div class="menu-card fade-in-up" style="--card-color: #ef4444; --card-dark: #dc2626;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-exclamation-triangle"></i>
          </div>
          <div>
            <div class="card-title">Riwayat Pelanggaran</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Lihat riwayat pelanggaran dan poin siswa</div>
          <a href="riwayat_pelanggaran.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Riwayat Bimbingan Konseling -->
      <div class="menu-card fade-in-up" style="--card-color: #8b5cf6; --card-dark: #7c3aed;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-hands-helping"></i>
          </div>
          <div>
            <div class="card-title">Riwayat Bimbingan Konseling</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Monitor sesi bimbingan dan konseling siswa</div>
          <a href="riwayat_bk.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Riwayat Daftar Ajuan Izin -->
      <div class="menu-card fade-in-up" style="--card-color: #3b82f6; --card-dark: #2563eb;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-envelope-open-text"></i>
          </div>
          <div>
            <div class="card-title">Riwayat Ajuan Izin</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Lihat riwayat pengajuan izin siswa</div>
          <a href="riwayat_izin.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>
    </div>

    <!-- Pengaturan & Lainnya -->
    <h3 class="section-subtitle fade-in-up">Pengaturan & Lainnya</h3>
    <div class="menu-grid">
      <!-- Pengaturan Key API WA -->
      <div class="menu-card fade-in-up" style="--card-color: #ec4899; --card-dark: #db2777;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fab fa-whatsapp"></i>
          </div>
          <div>
            <div class="card-title">Pengaturan Key API WA</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Kelola kunci API untuk integrasi WhatsApp</div>
          <a href="key_wa_sidobe.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Kirim WA Orang Tua/Wali Siswa -->
      <div class="menu-card fade-in-up" style="--card-color: #25d366; --card-dark: #128c7e;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fab fa-whatsapp"></i>
          </div>
          <div>
            <div class="card-title">Kirim WA Orang Tua/Wali</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Kirim pesan WhatsApp ke orang tua/wali siswa</div>
          <a href="wa-wali-siswa.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Hari Libur -->
      <div class="menu-card fade-in-up" style="--card-color: #10b981; --card-dark: #059669;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-plane"></i>
          </div>
          <div>
            <div class="card-title">Hari Libur</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Kelola hari libur dan cuti bersama</div>
          <a href="libur.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Hapus/Kosongkan Data -->
      <div class="menu-card fade-in-up" style="--card-color: #ef4444; --card-dark: #dc2626;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-trash"></i>
          </div>
          <div>
            <div class="card-title">Hapus/Kosongkan Data</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Kosongkan data absensi dan siswa</div>
          <a href="kosongkan_data.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Logout -->
      <div class="menu-card fade-in-up" style="--card-color: #ef4444; --card-dark: #dc2626;">
        <div class="card-header">
          <div class="card-icon">
            <i class="fas fa-sign-out-alt"></i>
          </div>
          <div>
            <div class="card-title">Logout</div>
          </div>
        </div>
        <div class="card-content">
          <div class="card-desc">Keluar dari sistem administrasi</div>
          <a href="logout.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Keluar
          </a>
        </div>
      </div>
    </div>
  </div>

  <footer class="footer">
    <div class="footer-content">
      <div class="version">Versi Aplikasi: 4.00 | &copy; <?php echo date('Y'); ?> Sistem Absensi QR Modern</div>
      <div class="footer-links">
        <a href="#"><i class="fas fa-question-circle"></i> Bantuan</a>
        <a href="#"><i class="fas fa-shield-alt"></i> Privasi</a>
        <a href="#"><i class="fas fa-file-contract"></i> Kebijakan</a>
      </div>
    </div>
  </footer>

  <script>
    // Theme Toggle
    function toggleTheme() {
      document.documentElement.classList.toggle('dark');
      const icon = document.querySelector('.theme-toggle i');
      if (document.documentElement.classList.contains('dark')) {
        icon.className = 'fas fa-sun';
        localStorage.setItem('theme', 'dark');
      } else {
        icon.className = 'fas fa-moon';
        localStorage.setItem('theme', 'light');
      }
    }

    // Load saved theme
    const savedTheme = localStorage.getItem('theme');
    if (savedTheme === 'dark') {
      document.documentElement.classList.add('dark');
      document.querySelector('.theme-toggle i').className = 'fas fa-sun';
    }

    // Animation on scroll
    const observerOptions = {
      threshold: 0.1,
      rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.style.animation = 'fadeInUp 0.6s ease-out forwards';
          observer.unobserve(entry.target);
        }
      });
    }, observerOptions);

    // Observe all cards for animation
    document.addEventListener('DOMContentLoaded', () => {
      const cards = document.querySelectorAll('.menu-card, .stat-card, .section-subtitle');
      cards.forEach(card => {
        observer.observe(card);
      });
    });

    // Auto refresh statistik setiap 2 menit
    setInterval(() => {
      location.reload();
    }, 120000);
  </script>
</body>
</html>