<?php
session_start();
include 'config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header("Location: index.php");
    exit;
}

if (!isset($_SESSION['siswa_id'])) {
    die("Data siswa tidak ditemukan, silakan login ulang.");
}

$siswa_id = intval($_SESSION['siswa_id']);
$username = $_SESSION['username'];

// Ambil data siswa
$q = mysqli_query($conn, "SELECT nama, kelas FROM siswa WHERE id = $siswa_id");
if (!$q) {
    die("Error: " . mysqli_error($conn));
}
$siswa = mysqli_fetch_assoc($q);

// Ambil user_id siswa dari tabel users
$qUserSiswa = mysqli_query($conn, "SELECT id FROM users WHERE username = '$username' AND role = 'siswa'");
if (!$qUserSiswa || mysqli_num_rows($qUserSiswa) === 0) {
    die("Data user siswa tidak ditemukan.");
}
$userSiswa = mysqli_fetch_assoc($qUserSiswa);
$siswa_user_id = $userSiswa['id'];

// Ambil data wali kelas dari tabel wali_kelas
$wali_kelas = ['id' => 0, 'nama_wali' => 'Wali Kelas', 'foto' => '', 'user_id' => 0];
$kelas = $siswa['kelas'];
$qWaliKelas = mysqli_query($conn, "SELECT id, nama_wali, nip_wali FROM wali_kelas WHERE kelas = '$kelas'");

if ($qWaliKelas && mysqli_num_rows($qWaliKelas) > 0) {
    $wali_kelas = mysqli_fetch_assoc($qWaliKelas);
    
    // Cari user_id wali kelas di tabel users
    $qUserWali = mysqli_query($conn, "SELECT id FROM users WHERE username = '{$wali_kelas['nip_wali']}' AND role = 'wali_kelas'");
    if ($qUserWali && mysqli_num_rows($qUserWali) > 0) {
        $userWali = mysqli_fetch_assoc($qUserWali);
        $wali_kelas['user_id'] = $userWali['id'];
    }
}
?>
<!DOCTYPE html>
<html lang="id" class="dark">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard Siswa - Sistem Absensi QR</title>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #6366f1;
      --primary-dark: #4f46e5;
      --primary-light: #8b5cf6;
      --secondary: #ec4899;
      --accent: #f59e0b;
      --success: #10b981;
      --warning: #f59e0b;
      --danger: #ef4444;
      --info: #3b82f6;
      --dark: #1f2937;
      --darker: #111827;
      --light: #f8fafc;
      --gray: #6b7280;
      --gray-light: #e5e7eb;
      --card-bg: #ffffff;
      --card-bg-dark: #374151;
      --text-primary: #1f2937;
      --text-primary-dark: #f9fafb;
      --text-secondary: #6b7280;
      --text-secondary-dark: #d1d5db;
      --border-radius: 16px;
      --shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
      --shadow-hover: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
      --shadow-dark: 0 10px 25px -5px rgba(0, 0, 0, 0.3), 0 8px 10px -6px rgba(0, 0, 0, 0.2);
      --gradient-primary: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
      --gradient-accent: linear-gradient(135deg, #ec4899 0%, #f59e0b 100%);
      --gradient-success: linear-gradient(135deg, #10b981 0%, #059669 100%);
      --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .dark {
      --card-bg: var(--card-bg-dark);
      --text-primary: var(--text-primary-dark);
      --text-secondary: var(--text-secondary-dark);
      --shadow: var(--shadow-dark);
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
      min-height: 100vh;
      color: var(--text-primary);
      line-height: 1.6;
      transition: var(--transition);
    }

    .dark body {
      background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
    }

    /* Header Styles */
    .header {
      background: var(--gradient-primary);
      color: white;
      padding: 1.5rem 2rem;
      box-shadow: var(--shadow);
      position: relative;
      overflow: hidden;
    }

    .header::before {
      content: '';
      position: absolute;
      top: -50%;
      right: -10%;
      width: 300px;
      height: 300px;
      background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
      border-radius: 50%;
    }

    .header-content {
      position: relative;
      z-index: 2;
      max-width: 1400px;
      margin: 0 auto;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .logo-section h1 {
      font-size: 1.75rem;
      font-weight: 700;
      margin-bottom: 0.25rem;
    }

    .logo-section .subtitle {
      font-size: 0.9rem;
      opacity: 0.9;
      font-weight: 400;
    }

    .user-info {
      background: rgba(255, 255, 255, 0.15);
      padding: 0.75rem 1.5rem;
      border-radius: var(--border-radius);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.2);
      display: flex;
      align-items: center;
      gap: 1rem;
    }

    .user-avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.2);
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.2rem;
    }

    .user-details .welcome {
      font-weight: 500;
      margin-bottom: 0.25rem;
    }

    .user-details .role {
      font-size: 0.85rem;
      opacity: 0.8;
    }

    /* Theme Toggle */
    .theme-toggle {
      background: rgba(255, 255, 255, 0.15);
      border: 1px solid rgba(255, 255, 255, 0.2);
      color: white;
      padding: 0.5rem;
      border-radius: 50%;
      cursor: pointer;
      transition: var(--transition);
      backdrop-filter: blur(10px);
    }

    .theme-toggle:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: rotate(45deg);
    }

    /* Main Content */
    .dashboard-container {
      max-width: 1400px;
      margin: 0 auto;
      padding: 2rem;
    }

    .section-title {
      font-size: 1.5rem;
      font-weight: 600;
      color: var(--text-primary);
      margin-bottom: 1.5rem;
      text-align: center;
      position: relative;
    }

    .section-title::after {
      content: '';
      display: block;
      width: 60px;
      height: 3px;
      background: var(--primary);
      margin: 0.5rem auto;
      border-radius: 2px;
    }

    /* Menu Grid */
    .menu-grid {
      display: grid;
      grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
      gap: 1.5rem;
      margin-bottom: 2rem;
    }

    .menu-card {
      background: var(--card-bg);
      border-radius: var(--border-radius);
      box-shadow: var(--shadow);
      transition: var(--transition);
      overflow: hidden;
      border: 1px solid rgba(0,0,0,0.05);
      position: relative;
      height: 100%;
      display: flex;
      flex-direction: column;
    }

    .dark .menu-card {
      border: 1px solid rgba(255,255,255,0.1);
    }

    .menu-card:hover {
      transform: translateY(-8px) scale(1.02);
      box-shadow: var(--shadow-hover);
    }

    .menu-card:before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 5px;
      background: var(--card-color, var(--primary));
    }

    .card-content {
      padding: 1.5rem;
      flex-grow: 1;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
    }

    .card-header {
      display: flex;
      align-items: center;
      gap: 1rem;
      margin-bottom: 1rem;
    }

    .card-icon {
      width: 50px;
      height: 50px;
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.5rem;
      color: white;
      background: var(--card-color, var(--primary));
      flex-shrink: 0;
    }

    .card-title {
      font-size: 1.1rem;
      font-weight: 600;
      color: var(--text-primary);
      margin-bottom: 0.25rem;
    }

    .card-desc {
      font-size: 0.875rem;
      color: var(--text-secondary);
      line-height: 1.5;
      margin-bottom: 1rem;
    }

    .card-button {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 0.5rem;
      width: 100%;
      padding: 0.75rem 1rem;
      background: var(--card-color, var(--primary));
      color: white;
      text-decoration: none;
      border-radius: 10px;
      font-weight: 500;
      font-size: 0.9rem;
      transition: var(--transition);
      border: none;
      cursor: pointer;
      margin-top: auto;
    }

    .card-button:hover {
      background: var(--card-dark, var(--primary-dark));
      transform: translateY(-2px);
      box-shadow: 0 8px 20px rgba(0,0,0,0.15);
    }

    /* Footer */
    .footer {
      background: var(--dark);
      color: white;
      text-align: center;
      padding: 1.5rem;
      margin-top: 3rem;
    }

    .footer-content {
      max-width: 1400px;
      margin: 0 auto;
    }

    .version {
      font-size: 0.875rem;
      opacity: 0.8;
    }

    /* Loading Animation */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .fade-in-up {
      animation: fadeInUp 0.6s ease-out;
    }

    /* Responsive Design */
    @media (max-width: 1024px) {
      .menu-grid {
        grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
      }
    }

    @media (max-width: 768px) {
      .header-content {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
      }

      .user-info {
        width: 100%;
        max-width: 300px;
      }

      .dashboard-container {
        padding: 1.5rem;
      }

      .menu-grid {
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 1rem;
      }
    }

    @media (max-width: 480px) {
      .header {
        padding: 1rem;
      }

      .dashboard-container {
        padding: 1rem;
      }

      .menu-grid {
        grid-template-columns: 1fr;
      }

      .card-header {
        padding: 1rem 1rem 0.5rem;
      }

      .card-content {
        padding: 0 1rem 1rem;
      }
    }
  </style>
</head>
<body>
  <!-- Header -->
  <header class="header">
    <div class="header-content">
      <div class="logo-section">
        <h1>Dashboard Siswa</h1>
        <div class="subtitle">Sistem Absensi QR Modern</div>
      </div>
      <div class="user-info">
        <div class="user-avatar">
          <i class="fas fa-user-graduate"></i>
        </div>
        <div class="user-details">
          <div class="welcome">Halo, <?php echo htmlspecialchars($siswa['nama']); ?></div>
          <div class="role"><?php echo htmlspecialchars($siswa['kelas']); ?></div>
        </div>
        <button class="theme-toggle" onclick="toggleTheme()">
          <i class="fas fa-moon"></i>
        </button>
      </div>
    </div>
  </header>

  <!-- Main Content -->
  <div class="dashboard-container">
    <!-- Hanya Menu Utama yang ditampilkan -->
    <h2 class="section-title">Menu Utama</h2>
    
    <div class="menu-grid">
      <!-- Kehadiran -->
      <div class="menu-card fade-in-up" style="--card-color: #10b981; --card-dark: #059669;">
        <div class="card-content">
          <div class="card-header">
            <div class="card-icon">
              <i class="fas fa-calendar-check"></i>
            </div>
            <div>
              <div class="card-title">Kehadiran</div>
            </div>
          </div>
          <div class="card-desc">Lihat riwayat kehadiran dan statistik absensi bulan ini</div>
          <a href="kehadiran_siswa.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Live Chat Wali Kelas -->
      <div class="menu-card fade-in-up" style="--card-color: #8b5cf6; --card-dark: #7c3aed;">
        <div class="card-content">
          <div class="card-header">
            <div class="card-icon">
              <i class="fas fa-comments"></i>
            </div>
            <div>
              <div class="card-title">Live Chat</div>
            </div>
          </div>
          <div class="card-desc">Chat langsung dengan wali kelas untuk konsultasi dan bimbingan</div>
          <a href="chat_wali_siswa.php" class="card-button">
            <i class="fas fa-comment"></i>
            Buka Chat
          </a>
        </div>
      </div>

      <!-- Perizinan -->
      <div class="menu-card fade-in-up" style="--card-color: #3b82f6; --card-dark: #2563eb;">
        <div class="card-content">
          <div class="card-header">
            <div class="card-icon">
              <i class="fas fa-envelope-open-text"></i>
            </div>
            <div>
              <div class="card-title">Perizinan</div>
            </div>
          </div>
          <div class="card-desc">Ajukan izin tidak masuk dengan keterangan lengkap</div>
          <a href="perizinan_siswa.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Pelanggaran -->
      <div class="menu-card fade-in-up" style="--card-color: #ef4444; --card-dark: #dc2626;">
        <div class="card-content">
          <div class="card-header">
            <div class="card-icon">
              <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div>
              <div class="card-title">Pelanggaran</div>
            </div>
          </div>
          <div class="card-desc">Lihat daftar pelanggaran dan poin yang tercatat</div>
          <a href="pelanggaran_siswa.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Bimbingan Konseling -->
      <div class="menu-card fade-in-up" style="--card-color: #8b5cf6; --card-dark: #7c3aed;">
        <div class="card-content">
          <div class="card-header">
            <div class="card-icon">
              <i class="fas fa-hands-helping"></i>
            </div>
            <div>
              <div class="card-title">Bimbingan Konseling</div>
            </div>
          </div>
          <div class="card-desc">Ajukan konsultasi dan lihat riwayat bimbingan</div>
          <a href="bimbingan_siswa.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Akun -->
      <div class="menu-card fade-in-up" style="--card-color: #6b7280; --card-dark: #4b5563;">
        <div class="card-content">
          <div class="card-header">
            <div class="card-icon">
              <i class="fas fa-user-cog"></i>
            </div>
            <div>
              <div class="card-title">Akun</div>
            </div>
          </div>
          <div class="card-desc">Kelola informasi akun dan ubah password</div>
          <a href="akun_siswa.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Akses Menu
          </a>
        </div>
      </div>

      <!-- Logout -->
      <div class="menu-card fade-in-up" style="--card-color: #ef4444; --card-dark: #dc2626;">
        <div class="card-content">
          <div class="card-header">
            <div class="card-icon">
              <i class="fas fa-sign-out-alt"></i>
            </div>
            <div>
              <div class="card-title">Logout</div>
            </div>
          </div>
          <div class="card-desc">Keluar dari sistem dengan aman</div>
          <a href="logout.php" class="card-button">
            <i class="fas fa-arrow-right"></i>
            Keluar
          </a>
        </div>
      </div>
    </div>
  </div>

  <footer class="footer">
    <div class="footer-content">
      <div class="version">Versi Aplikasi: 4.00 | &copy; <?php echo date('Y'); ?> Sistem Absensi QR Modern</div>
    </div>
  </footer>

  <script>
    // Theme Toggle
    function toggleTheme() {
      document.documentElement.classList.toggle('dark');
      const icon = document.querySelector('.theme-toggle i');
      if (document.documentElement.classList.contains('dark')) {
        icon.className = 'fas fa-sun';
        localStorage.setItem('theme', 'dark');
      } else {
        icon.className = 'fas fa-moon';
        localStorage.setItem('theme', 'light');
      }
    }

    // Load saved theme
    const savedTheme = localStorage.getItem('theme');
    if (savedTheme === 'dark') {
      document.documentElement.classList.add('dark');
      document.querySelector('.theme-toggle i').className = 'fas fa-sun';
    }

    // Animation on scroll
    const observerOptions = {
      threshold: 0.1,
      rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.style.animation = 'fadeInUp 0.6s ease-out forwards';
          observer.unobserve(entry.target);
        }
      });
    }, observerOptions);

    // Observe all cards for animation
    document.addEventListener('DOMContentLoaded', () => {
      const cards = document.querySelectorAll('.menu-card');
      cards.forEach(card => {
        observer.observe(card);
      });
    });
  </script>
</body>
</html>