<?php
include 'config.php';

header("Content-Type: application/vnd-ms-excel");
header("Content-Disposition: attachment; filename=rekap_absen.xls");

// Ambil parameter yang sama dengan halaman rekap.php
$tanggal = $_GET['tanggal'] ?? date("Y-m-d");
$tanggal_akhir = $_GET['tanggal_akhir'] ?? $tanggal;
$filter_tanggal = $_GET['filter_tanggal'] ?? 'hari';
$kelasFilter = $_GET['kelas'] ?? "";
$namaFilter = $_GET['nama'] ?? "";
$statusFilter = $_GET['status'] ?? "";

// Cek koneksi database
if (!$conn) {
    die("Koneksi database gagal: " . mysqli_connect_error());
}

// Ambil data kepala sekolah
$profil_query = mysqli_query($conn, "SELECT * FROM profil_sekolah LIMIT 1");
if (!$profil_query) {
    die("Error query profil: " . mysqli_error($conn));
}
$profil = mysqli_fetch_assoc($profil_query);
$kepalaSekolah = $profil['kepala_sekolah'] ?? 'Nama Kepala Sekolah';
$nipKepala = $profil['nip_kepala'] ?? 'NIP Kepala Sekolah';
$namaSekolah = $profil['nama'] ?? 'Nama Sekolah';

// Ambil data wali kelas (jika kelas dipilih)
$waliKelas = '';
$nipWali = '';
if ($kelasFilter != '' && $kelasFilter != 'Semua Kelas') {
    $wali_query = mysqli_query($conn, "SELECT nama_wali, nip_wali FROM wali_kelas WHERE kelas='$kelasFilter' LIMIT 1");
    if ($wali_query && mysqli_num_rows($wali_query) > 0) {
        $dataWali = mysqli_fetch_assoc($wali_query);
        $waliKelas = $dataWali['nama_wali'];
        $nipWali = $dataWali['nip_wali'];
    }
}

// Format periode untuk tampilan
$namaBulan = [
    '01' => 'Januari', '02' => 'Februari', '03' => 'Maret', '04' => 'April',
    '05' => 'Mei', '06' => 'Juni', '07' => 'Juli', '08' => 'Agustus',
    '09' => 'September', '10' => 'Oktober', '11' => 'November', '12' => 'Desember'
];

$bulan = date('m', strtotime($tanggal));
$tahun = date('Y', strtotime($tanggal));
$periode = $namaBulan[$bulan] . ' ' . $tahun;

// Query data absensi - disesuaikan dengan struktur dari rekap.php
$sql = "
    SELECT 
        a.id, 
        s.id AS siswa_id, 
        s.nis,
        s.nama, 
        s.kelas, 
        a.jam AS jam_masuk, 
        a.jam_pulang,
        a.status,
        a.keterangan,
        a.tanggal
    FROM absensi a
    JOIN siswa s ON a.siswa_id = s.id
    WHERE s.status = 'aktif'
";

// Filter tanggal
if ($filter_tanggal == 'hari') {
    $sql .= " AND a.tanggal = '" . mysqli_real_escape_string($conn, $tanggal) . "'";
} else {
    $sql .= " AND a.tanggal BETWEEN '" . mysqli_real_escape_string($conn, $tanggal) . "' AND '" . mysqli_real_escape_string($conn, $tanggal_akhir) . "'";
}

// Filter lainnya
if ($kelasFilter !== "") {
    $sql .= " AND s.kelas = '" . mysqli_real_escape_string($conn, $kelasFilter) . "'";
}
if ($namaFilter !== "") {
    $sql .= " AND s.nama LIKE '%" . mysqli_real_escape_string($conn, $namaFilter) . "%'";
}
if ($statusFilter !== "") {
    $sql .= " AND a.status = '" . mysqli_real_escape_string($conn, $statusFilter) . "'";
}

// Tambahkan sorting
$sql .= " ORDER BY a.tanggal DESC, s.kelas, s.nama";

$result = mysqli_query($conn, $sql);

// Cek jika query berhasil
if (!$result) {
    die("Error query absensi: " . mysqli_error($conn));
}

// Fungsi untuk mendapatkan teks status
function getStatusText($status) {
    switch($status) {
        case 'H': return 'Hadir';
        case 'I': return 'Izin';
        case 'S': return 'Sakit';
        case 'A': return 'Alpa';
        default: return $status;
    }
}

// Header laporan
echo "<meta charset='UTF-8'>";
echo "<h2>Hasil Rekap Kehadiran</h2>";
echo "<p><strong>Periode:</strong> " . ($filter_tanggal == 'hari' ? date("d/m/Y", strtotime($tanggal)) : date("d/m/Y", strtotime($tanggal)) . " - " . date("d/m/Y", strtotime($tanggal_akhir))) . "</p>";
echo "<p><strong>Kelas:</strong> " . ($kelasFilter == '' ? 'Semua Kelas' : $kelasFilter) . "</p>";
echo "<p><strong>Status:</strong> " . ($statusFilter == '' ? 'Semua Status' : getStatusText($statusFilter)) . "</p>";

// Output tabel absensi
echo "<table border='1'>
<tr>
  <th>No</th>
  <th>Tanggal</th>
  <th>NIS</th>
  <th>Nama</th>
  <th>Kelas</th>
  <th>Jam Masuk</th>
  <th>Jam Pulang</th>
  <th>Status</th>
  <th>Keterangan</th>
</tr>";

$no = 1;
while ($row = mysqli_fetch_assoc($result)) {
  $jamPulang = empty($row['jam_pulang']) ? 'Belum absen pulang' : $row['jam_pulang'];
  $jamMasuk = empty($row['jam_masuk']) ? '-' : $row['jam_masuk'];
  $statusText = getStatusText($row['status']);
  
  echo "<tr>
    <td>$no</td>
    <td>" . date('d/m/Y', strtotime($row['tanggal'])) . "</td>
    <td>{$row['nis']}</td>
    <td>{$row['nama']}</td>
    <td>{$row['kelas']}</td>
    <td>$jamMasuk</td>
    <td>$jamPulang</td>
    <td>$statusText</td>
    <td>{$row['keterangan']}</td>
  </tr>";
  $no++;
}
echo "</table>";

// Footer dengan catatan
echo "<br><p><strong>Notation:</strong></p>";
echo "<ul>";
echo "<li>Muhammad Bayu Aditiya Al-Ghozali</li>";
echo "<li>Bakun Absen pulang</li>";
echo "<li>Hadir</li>";
echo "<li>Pulang</li>";
echo "<li>Tekrar</li>";
echo "<li>Servi</li>";
echo "</ul>";

// Spasi sebelum tanda tangan
echo "<br><br><table width='100%' style='border:0;'>
<tr>
  <td width='50%' align='center'>
    Mengetahui,<br>
    Kepala Sekolah<br><br><br><br>
    <u>$kepalaSekolah</u><br>
    NIP. $nipKepala
  </td>
  <td width='50%' align='center'>
    " . date('d/m/Y') . "<br>
    Wali Kelas " . ($kelasFilter == '' || $kelasFilter == 'Semua Kelas' ? '' : $kelasFilter) . "<br><br><br><br>
    <u>$waliKelas</u><br>
    NIP. $nipWali
  </td>
</tr>
</table>";

// Tutup koneksi
mysqli_close($conn);
?>