<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'wali_kelas') {
    header("Location: index.php");
    exit;
}

include 'config.php';

// Ambil kelas yang diampu oleh wali kelas
$username = $_SESSION['username'];
$wali_kelas = mysqli_fetch_assoc(mysqli_query($conn, "SELECT kelas FROM wali_kelas WHERE nip_wali='$username' LIMIT 1"));
$kelas_diampu = $wali_kelas['kelas'] ?? '';

if (empty($kelas_diampu)) {
    die("<script>alert('Anda tidak memiliki kelas yang diampu!'); window.location='dashboard_wali_kelas.php';</script>");
}

$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');

// Dapatkan tanggal hari ini untuk perbandingan
$hariIni = date('d');
$bulanIni = date('m');
$tahunIni = date('Y');
$today = date('Y-m-d');

// Ambil nama sekolah
$profil = mysqli_fetch_assoc(mysqli_query($conn, "SELECT nama_sekolah, kepala_sekolah, nip_kepala FROM profil_sekolah LIMIT 1"));
$nama_sekolah = $profil['nama_sekolah'] ?? 'Nama Sekolah';

// Hitung jumlah hari dalam bulan
$jumlahHari = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);

// Ambil daftar hari libur dari database
$libur = [];
$queryLibur = mysqli_query($conn, "SELECT tanggal FROM hari_libur");
while ($row = mysqli_fetch_assoc($queryLibur)) {
  $libur[] = $row['tanggal'];
}

// Ambil data wali kelas
$wali_nama = '....................................';
$wali_nip = '........................';
$qWali = mysqli_query($conn, "SELECT nama_wali, nip_wali FROM wali_kelas WHERE kelas = '$kelas_diampu' LIMIT 1");
if ($w = mysqli_fetch_assoc($qWali)) {
    $wali_nama = $w['nama_wali'];
    $wali_nip = $w['nip_wali'];
}

// Ambil daftar siswa hanya dari kelas yang diampu
$sqlSiswa = "SELECT id, nis, nama, kelas FROM siswa WHERE status='aktif' AND kelas = '$kelas_diampu' ORDER BY nama";
$siswaResult = mysqli_query($conn, $sqlSiswa);

// Ambil data absensi dari scan untuk kelas yang diampu
$absensi = [];
$absensiQuery = "SELECT a.*, s.nis, s.nama FROM absensi a 
                 JOIN siswa s ON a.siswa_id = s.id 
                 WHERE MONTH(a.tanggal) = '$bulan' 
                   AND YEAR(a.tanggal) = '$tahun'
                   AND s.status='aktif'
                   AND s.kelas = '$kelas_diampu'";
$resultAbsensi = mysqli_query($conn, $absensiQuery);

while ($row = mysqli_fetch_assoc($resultAbsensi)) {
  $sid = $row['siswa_id'];
  $tgl = (int)date('j', strtotime($row['tanggal']));
  $absensi[$sid][$tgl] = $row['status'];
}

// Ambil data izin yang disetujui untuk kelas yang diampu
$izin_data = [];
$izinQuery = "SELECT p.siswa_id, p.tanggal_izin, p.jenis_izin, p.keterangan 
              FROM perizinan p 
              JOIN siswa s ON p.siswa_id = s.id 
              WHERE MONTH(p.tanggal_izin) = '$bulan' 
              AND YEAR(p.tanggal_izin) = '$tahun' 
              AND s.status='aktif'
              AND s.kelas = '$kelas_diampu'
              AND p.status = 'approved'";
$resultIzin = mysqli_query($conn, $izinQuery);

while ($izin = mysqli_fetch_assoc($resultIzin)) {
  $sid = $izin['siswa_id'];
  $tgl = (int)date('j', strtotime($izin['tanggal_izin']));
  $izin_data[$sid][$tgl] = $izin['jenis_izin'];
}

// Hitung rekap absensi per siswa dengan sinkronisasi data
$rekap = [];
$totalGlobal = ['H' => 0, 'I' => 0, 'S' => 0, 'A' => 0];

// Reset pointer untuk mengulang query siswa
mysqli_data_seek($siswaResult, 0);
while ($siswa = mysqli_fetch_assoc($siswaResult)) {
    $sid = $siswa['id'];
    $rekap[$sid] = [
        'nis' => $siswa['nis'],
        'nama' => $siswa['nama'],
        'kelas' => $siswa['kelas'],
        'H' => 0,
        'I' => 0,
        'S' => 0,
        'A' => 0
    ];

    // Hitung absensi dengan sinkronisasi data
    for ($i = 1; $i <= $jumlahHari; $i++) {
        $tanggal = "$tahun-" . str_pad($bulan, 2, '0', STR_PAD_LEFT) . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
        $day = date('w', strtotime($tanggal));
        $isLibur = in_array($tanggal, $libur);
        
        // Tentukan apakah hari ini adalah hari mendatang
        $isHariMendatang = false;
        if ($tahun == $tahunIni && $bulan == $bulanIni && $i > $hariIni) {
            $isHariMendatang = true;
        } elseif ($tahun == $tahunIni && $bulan > $bulanIni) {
            $isHariMendatang = true;
        } elseif ($tahun > $tahunIni) {
            $isHariMendatang = true;
        }
        
        // Skip jika hari mendatang, libur, atau minggu
        if ($isHariMendatang || $day == 0 || $isLibur) {
            continue;
        }
        
        // LOGIKA SINKRONISASI: Prioritaskan izin yang disetujui, lalu absensi dari scan
        $status = '';
        
        // 1. Cek apakah ada izin yang disetujui untuk tanggal ini
        if (isset($izin_data[$sid][$i])) {
            $jenis_izin = $izin_data[$sid][$i];
            if ($jenis_izin == 'Sakit') {
                $status = 'S';
            } else {
                $status = 'I';
            }
        }
        // 2. Cek apakah ada absensi dari scan untuk tanggal ini
        elseif (isset($absensi[$sid][$i])) {
            $status = $absensi[$sid][$i];
        }
        // 3. Jika tidak ada data sama sekali = Alpha
        else {
            $status = 'A';
        }
        
        // Hitung berdasarkan status yang sudah ditentukan
        if ($status == 'H') {
            $rekap[$sid]['H']++;
            $totalGlobal['H']++;
        } elseif ($status == 'I') {
            $rekap[$sid]['I']++;
            $totalGlobal['I']++;
        } elseif ($status == 'S') {
            $rekap[$sid]['S']++;
            $totalGlobal['S']++;
        } elseif ($status == 'A') {
            $rekap[$sid]['A']++;
            $totalGlobal['A']++;
        }
    }
}

// Hitung total hari aktif (hari kerja yang sudah lewat)
$totalHariAktif = 0;
for ($i = 1; $i <= $jumlahHari; $i++) {
    $tanggal = "$tahun-" . str_pad($bulan, 2, '0', STR_PAD_LEFT) . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
    $day = date('w', strtotime($tanggal));
    $isLibur = in_array($tanggal, $libur);
    
    // Tentukan apakah hari ini adalah hari mendatang
    $isHariMendatang = false;
    if ($tahun == $tahunIni && $bulan == $bulanIni && $i > $hariIni) {
        $isHariMendatang = true;
    } elseif ($tahun == $tahunIni && $bulan > $bulanIni) {
        $isHariMendatang = true;
    } elseif ($tahun > $tahunIni) {
        $isHariMendatang = true;
    }
    
    // Hanya hitung hari kerja yang sudah lewat
    if (!$isHariMendatang && $day != 0 && !$isLibur) {
        $totalHariAktif++;
    }
}

// Tanggal terakhir bulan ini
$tanggal_terakhir = date("j F Y", strtotime("$tahun-$bulan-" . cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun)));
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Prosentase Kehadiran - <?php echo $kelas_diampu; ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
    body { font-family: Arial, sans-serif; margin: 20px; }
    h2 { text-align: center; margin-bottom: 5px; }
    form { text-align: center; margin-bottom: 20px; }
    select, input, button { padding: 5px; margin: 3px; }
    table { border-collapse: collapse; width: 100%; font-size: 14px; }
    th, td { border: 1px solid #ddd; padding: 6px; text-align: center; }
    th { background: #f4f4f4; }
    .summary { display: flex; justify-content: center; margin: 20px 0; gap: 20px; flex-wrap: wrap; }
    .box { padding: 10px 20px; border-radius: 8px; font-weight: bold; font-size: 16px; min-width: 120px; text-align: center; }
    .hadir { background: #dff0d8; color: #2e7d32; }
    .izin { background: #e3f2fd; color: #1565c0; }
    .sakit { background: #fff8e1; color: #ef6c00; }
    .alpha { background: #ffebee; color: #c62828; }
    .predikat { font-weight: bold; padding: 3px 6px; border-radius: 4px; display: inline-block; }
    .sangatbaik { background: #c8e6c9; color: #256029; }
    .baik { background: #bbdefb; color: #0d47a1; }
    .cukup { background: #fff9c4; color: #f57f17; }
    .kurang { background: #ffe0b2; color: #e65100; }
    .btn-back { 
        padding: 5px 10px; 
        background: #6c757d; 
        color: #fff; 
        text-decoration: none; 
        border-radius: 4px; 
        margin-left: 10px;
        display: inline-block;
        margin-bottom: 10px;
    }
    .info-box {
        background: #e3f2fd;
        padding: 10px;
        border-radius: 5px;
        margin: 10px 0;
        text-align: center;
        font-size: 12px;
    }
</style>
</head>
<body>

<h2><?= $nama_sekolah ?><br>
Prosentase Kehadiran - <?= date('F Y', strtotime("$tahun-$bulan-01")) ?><br>
Kelas <?= $kelas_diampu ?></h2>

<!-- Form filter -->
<form method="get">
    <label>Bulan:
      <select name="bulan">
        <?php for ($b = 1; $b <= 12; $b++) {
          $sel = ($b == $bulan) ? 'selected' : '';
          echo "<option $sel value='$b'>" . date('F', mktime(0, 0, 0, $b, 10)) . "</option>";
        } ?>
      </select>
    </label>

    <label>Tahun:
      <input type="number" name="tahun" value="<?= $tahun ?>" style="width:80px;">
    </label>

    <button type="submit">Tampilkan</button>
    <a href="cetak_absen.php?kelas=<?= $kelas_diampu ?>&bulan=<?= $bulan ?>&tahun=<?= $tahun ?>" target="_blank" style="padding:5px 10px; background:#28a745; color:#fff; text-decoration:none; border-radius:4px;">Cetak PDF</a>
    <a href="dashboard_wali_kelas.php" class="btn-back">⬅ Kembali</a>
</form>

<div class="info-box">
    <strong>Data sudah sinkron dengan:</strong> Scan QR Code & Izin yang Disetujui | 
    <strong>Hari Aktif:</strong> <?= $totalHariAktif ?> hari (tidak termasuk libur, minggu, dan tanggal mendatang)
</div>

<!-- Ringkasan -->
<div class="summary">
    <div class="box hadir"><?= $totalGlobal['H'] ?> <br>Total Hadir</div>
    <div class="box izin"><?= $totalGlobal['I'] ?> <br>Total Izin</div>
    <div class="box sakit"><?= $totalGlobal['S'] ?> <br>Total Sakit</div>
    <div class="box alpha"><?= $totalGlobal['A'] ?> <br>Total Alpha</div>
</div>

<!-- Tabel absensi -->
<table>
    <tr>
        <th>No</th>
        <th>NIS</th>
        <th>Nama Siswa</th>
        <th>Kelas</th>
        <th>Hadir</th>
        <th>Izin</th>
        <th>Sakit</th>
        <th>Alpha</th>
        <th>Persentase & Predikat</th>
    </tr>
    <?php
    $no = 1;
    foreach ($rekap as $r) {
        $totalHadir = $r['H'];
        $izin = $r['I'];
        $sakit = $r['S'];
        $alpha = $r['A'];
        $totalAbsen = $totalHadir + $izin + $sakit + $alpha;

        $persen = $totalHariAktif > 0 ? round(($totalHadir / $totalHariAktif) * 100, 1) : 0;

        // Tentukan predikat
        if ($persen == 100) {
            $predikat = "<span class='predikat sangatbaik'>100% Sangat Baik</span>";
        } elseif ($persen >= 90) {
            $predikat = "<span class='predikat baik'>{$persen}% Baik</span>";
        } elseif ($persen >= 80) {
            $predikat = "<span class='predikat cukup'>{$persen}% Cukup</span>";
        } else {
            $predikat = "<span class='predikat kurang'>{$persen}% Kurang</span>";
        }

        echo "<tr>
            <td>$no</td>
            <td>{$r['nis']}</td>
            <td style='text-align:left'>{$r['nama']}</td>
            <td>{$r['kelas']}</td>
            <td>{$totalHadir}</td>
            <td>{$izin}</td>
            <td>{$sakit}</td>
            <td>{$alpha}</td>
            <td>$predikat</td>
        </tr>";
        $no++;
    }
    ?>
</table>

<br><br>
<table style="width:100%; border:0; font-size:14px; text-align:center;">
    <tr>
      <td style="width:50%;">
        Mengetahui,<br>
        Kepala Sekolah<br><br><br><br>
        <u><?= $profil['kepala_sekolah'] ?? '....................................' ?></u><br>
        NIP. <?= $profil['nip_kepala'] ?? '........................' ?>
      </td>
      <td style="width:50%;">
        <?= $tanggal_terakhir ?><br>
        Wali Kelas <?= $kelas_diampu ?><br><br><br><br>
        <u><?= $wali_nama ?></u><br>
        NIP. <?= $wali_nip ?>
      </td>
    </tr>
</table>

</body>
</html>