<?php
// Cek apakah sedang update (maintenance mode aktif)
if (file_exists(__DIR__ . "/maintenance.flag")) {
    die("<h1>Sedang update, silakan coba beberapa menit lagi...</h1>");
}
include "config.php";

// Ambil data profil sekolah
$profil = mysqli_fetch_assoc(mysqli_query($conn, "SELECT nama_sekolah, logo FROM profil_sekolah LIMIT 1"));
$nama_sekolah = $profil['nama_sekolah'] ?? 'Nama Sekolah';
$logo = $profil['logo'] ?? 'default.png';
?>
<!DOCTYPE html>
<html lang="id" class="dark">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login - Sistem Absensi QR</title>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #6366f1;
      --primary-dark: #4f46e5;
      --primary-light: #8b5cf6;
      --secondary: #ec4899;
      --accent: #f59e0b;
      --success: #10b981;
      --warning: #f59e0b;
      --danger: #ef4444;
      --info: #3b82f6;
      --dark: #1f2937;
      --darker: #111827;
      --light: #f8fafc;
      --gray: #6b7280;
      --gray-light: #e5e7eb;
      --card-bg: #ffffff;
      --card-bg-dark: #374151;
      --text-primary: #1f2937;
      --text-primary-dark: #f9fafb;
      --text-secondary: #6b7280;
      --text-secondary-dark: #d1d5db;
      --border-radius: 16px;
      --shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
      --shadow-hover: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
      --shadow-dark: 0 10px 25px -5px rgba(0, 0, 0, 0.3), 0 8px 10px -6px rgba(0, 0, 0, 0.2);
      --gradient-primary: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
      --gradient-accent: linear-gradient(135deg, #ec4899 0%, #f59e0b 100%);
      --gradient-success: linear-gradient(135deg, #10b981 0%, #059669 100%);
      --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .dark {
      --card-bg: var(--card-bg-dark);
      --text-primary: var(--text-primary-dark);
      --text-secondary: var(--text-secondary-dark);
      --shadow: var(--shadow-dark);
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      min-height: 100vh;
      color: var(--text-primary);
      line-height: 1.6;
      transition: var(--transition);
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 1rem;
      overflow-x: hidden;
    }

    .dark body {
      background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
    }

    /* Animated Background */
    .floating-shapes {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      pointer-events: none;
      z-index: -1;
    }

    .shape {
      position: absolute;
      background: rgba(255, 255, 255, 0.1);
      border-radius: 50%;
      animation: float 6s ease-in-out infinite;
    }

    .shape:nth-child(1) {
      width: 80px;
      height: 80px;
      top: 20%;
      left: 10%;
      animation-delay: 0s;
    }

    .shape:nth-child(2) {
      width: 120px;
      height: 120px;
      top: 60%;
      left: 80%;
      animation-delay: 2s;
    }

    .shape:nth-child(3) {
      width: 60px;
      height: 60px;
      top: 80%;
      left: 20%;
      animation-delay: 4s;
    }

    .shape:nth-child(4) {
      width: 100px;
      height: 100px;
      top: 30%;
      left: 70%;
      animation-delay: 1s;
    }

    /* Login Container */
    .login-container {
      background: var(--card-bg);
      border-radius: var(--border-radius);
      box-shadow: var(--shadow);
      width: 100%;
      max-width: 450px;
      padding: 2rem;
      position: relative;
      overflow: hidden;
      border: 1px solid rgba(0,0,0,0.05);
      animation: slideUp 0.8s cubic-bezier(0.4, 0, 0.2, 1);
      transform-origin: center;
    }

    .dark .login-container {
      border: 1px solid rgba(255,255,255,0.1);
    }

    .login-container::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 4px;
      background: var(--gradient-primary);
    }

    /* School Header */
    .school-header {
      text-align: center;
      margin-bottom: 1.5rem;
      animation: fadeIn 0.8s ease-out 0.2s both;
    }

    .school-logo {
      width: 70px;
      height: 70px;
      border-radius: 50%;
      background: var(--gradient-primary);
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 0.75rem;
      box-shadow: var(--shadow);
      animation: bounceIn 0.8s ease-out 0.3s both;
    }

    .school-logo img {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      object-fit: cover;
    }

    .school-header h1 {
      font-size: 1.4rem;
      font-weight: 700;
      color: var(--text-primary);
      margin-bottom: 0.25rem;
    }

    .school-header .subtitle {
      font-size: 0.85rem;
      color: var(--text-secondary);
      font-weight: 400;
    }

    /* Role Selector */
    .role-selector {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      gap: 0.5rem;
      margin-bottom: 1.5rem;
      animation: fadeIn 0.8s ease-out 0.4s both;
    }

    .role-option {
      background: rgba(99, 102, 241, 0.05);
      border: 2px solid transparent;
      border-radius: 10px;
      padding: 0.75rem 0.5rem;
      text-align: center;
      cursor: pointer;
      transition: var(--transition);
      font-size: 0.7rem;
      font-weight: 500;
    }

    .dark .role-option {
      background: rgba(99, 102, 241, 0.1);
    }

    .role-option:hover {
      transform: translateY(-2px);
      box-shadow: var(--shadow);
    }

    .role-option.active {
      border-color: var(--primary);
      background: rgba(99, 102, 241, 0.15);
      color: var(--primary);
    }

    .role-icon {
      font-size: 1.1rem;
      margin-bottom: 0.25rem;
      display: block;
    }

    /* Form Styles */
    .form-group {
      margin-bottom: 1.25rem;
      animation: fadeIn 0.8s ease-out 0.5s both;
    }

    .form-label {
      display: block;
      font-weight: 500;
      margin-bottom: 0.5rem;
      color: var(--text-primary);
      font-size: 0.9rem;
    }

    .form-input {
      width: 100%;
      padding: 0.875rem 1rem;
      border: 1px solid var(--gray-light);
      border-radius: 10px;
      background: var(--card-bg);
      color: var(--text-primary);
      font-size: 0.9rem;
      transition: var(--transition);
    }

    .dark .form-input {
      border-color: rgba(255,255,255,0.2);
      background: var(--card-bg-dark);
    }

    .form-input:focus {
      outline: none;
      border-color: var(--primary);
      box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
      transform: translateY(-1px);
    }

    .form-input::placeholder {
      color: var(--text-secondary);
    }

    /* Button Styles */
    .btn {
      width: 100%;
      padding: 0.875rem 1.5rem;
      border: none;
      border-radius: 10px;
      font-weight: 600;
      font-size: 0.9rem;
      cursor: pointer;
      transition: var(--transition);
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 0.5rem;
      animation: fadeIn 0.8s ease-out 0.6s both;
    }

    .btn-primary {
      background: var(--gradient-primary);
      color: white;
      position: relative;
      overflow: hidden;
    }

    .btn-primary::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
      transition: left 0.5s;
    }

    .btn-primary:hover::before {
      left: 100%;
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: var(--shadow-hover);
    }

    /* Info Box */
    .info-box {
      background: rgba(59, 130, 246, 0.1);
      border: 1px solid rgba(59, 130, 246, 0.2);
      border-radius: 10px;
      padding: 1rem;
      margin-bottom: 1.5rem;
      font-size: 0.8rem;
      animation: fadeIn 0.8s ease-out 0.7s both;
    }

    .dark .info-box {
      background: rgba(59, 130, 246, 0.05);
      border-color: rgba(59, 130, 246, 0.3);
    }

    .info-box h4 {
      color: var(--primary);
      margin-bottom: 0.5rem;
      font-size: 0.85rem;
    }

    .info-box ul {
      list-style: none;
      padding-left: 0;
    }

    .info-box li {
      margin-bottom: 0.25rem;
      display: flex;
      align-items: center;
      gap: 0.5rem;
    }

    .info-box .badge {
      background: var(--primary);
      color: white;
      padding: 0.1rem 0.4rem;
      border-radius: 4px;
      font-size: 0.7rem;
      font-weight: 600;
    }

    /* Footer Links */
    .footer-links {
      margin-top: 1.5rem;
      text-align: center;
      padding-top: 1.5rem;
      border-top: 1px solid var(--gray-light);
      animation: fadeIn 0.8s ease-out 0.8s both;
    }

    .dark .footer-links {
      border-top: 1px solid rgba(255,255,255,0.1);
    }

    .footer-links a {
      color: var(--primary);
      text-decoration: none;
      font-size: 0.8rem;
      margin: 0 0.75rem;
      font-weight: 500;
      transition: var(--transition);
      position: relative;
    }

    .footer-links a::after {
      content: '';
      position: absolute;
      bottom: -2px;
      left: 0;
      width: 0;
      height: 2px;
      background: var(--primary);
      transition: width 0.3s ease;
    }

    .footer-links a:hover::after {
      width: 100%;
    }

    .app-version {
      margin-top: 1rem;
      font-size: 0.75rem;
      color: var(--text-secondary);
    }

    /* Theme Toggle */
    .theme-toggle {
      position: absolute;
      top: 1rem;
      right: 1rem;
      background: var(--card-bg);
      border: 1px solid var(--gray-light);
      color: var(--text-primary);
      padding: 0.5rem;
      border-radius: 50%;
      cursor: pointer;
      transition: var(--transition);
      box-shadow: var(--shadow);
      animation: fadeIn 0.8s ease-out 0.8s both;
    }

    .dark .theme-toggle {
      border-color: rgba(255,255,255,0.2);
    }

    .theme-toggle:hover {
      transform: rotate(45deg) scale(1.1);
      background: var(--primary);
      color: white;
    }

    /* Animations */
    @keyframes slideUp {
      from {
        opacity: 0;
        transform: translateY(50px) scale(0.9);
      }
      to {
        opacity: 1;
        transform: translateY(0) scale(1);
      }
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    @keyframes bounceIn {
      0% {
        opacity: 0;
        transform: scale(0.3);
      }
      50% {
        opacity: 1;
        transform: scale(1.05);
      }
      70% {
        transform: scale(0.9);
      }
      100% {
        opacity: 1;
        transform: scale(1);
      }
    }

    @keyframes float {
      0%, 100% {
        transform: translateY(0) rotate(0deg);
      }
      50% {
        transform: translateY(-20px) rotate(180deg);
      }
    }

    @keyframes pulse {
      0%, 100% {
        transform: scale(1);
      }
      50% {
        transform: scale(1.05);
      }
    }

    /* Responsive Design */
    @media (max-width: 480px) {
      .login-container {
        padding: 1.5rem;
        max-width: 350px;
      }
      
      .school-header h1 {
        font-size: 1.25rem;
      }
      
      .role-selector {
        grid-template-columns: 1fr;
        gap: 0.25rem;
      }
      
      .role-option {
        padding: 0.5rem;
        font-size: 0.65rem;
      }
      
      .footer-links a {
        margin: 0 0.5rem;
        font-size: 0.75rem;
      }
      
      .info-box {
        padding: 0.75rem;
        font-size: 0.75rem;
      }
    }
  </style>
</head>
<body>
  <!-- Animated Background -->
  <div class="floating-shapes">
    <div class="shape"></div>
    <div class="shape"></div>
    <div class="shape"></div>
    <div class="shape"></div>
  </div>

  <div class="login-container">
    <!-- Theme Toggle -->
    <button class="theme-toggle" onclick="toggleTheme()">
      <i class="fas fa-moon"></i>
    </button>

    <!-- School Header -->
    <div class="school-header">
      <div class="school-logo">
        <img src="uploads/<?php echo htmlspecialchars($logo); ?>" alt="Logo Sekolah" onerror="this.style.display='none'">
      </div>
      <h1><?php echo htmlspecialchars($nama_sekolah); ?></h1>
      <div class="subtitle">Sistem Absensi 3 Role</div>
    </div>

    <!-- Role Selector -->
    <div class="role-selector">
      <div class="role-option active" onclick="selectRole('siswa')">
        <i class="fas fa-users role-icon"></i>
        Wali Murid
      </div>
      <div class="role-option" onclick="selectRole('admin')">
        <i class="fas fa-user-shield role-icon"></i>
        Admin
      </div>
      <div class="role-option" onclick="selectRole('wali_kelas')">
        <i class="fas fa-user-tie role-icon"></i>
        Wali Kelas
      </div>
    </div>

    <!-- Login Info -->
    <div class="info-box">
      <h4><i class="fas fa-info-circle"></i> Informasi Login:</h4>
      <ul>
        <li><span class="badge">Admin</span> Username: <strong>admin</strong> | Password: <strong>admin123</strong></li>
        <li><span class="badge">Wali Kelas</span> Username: <strong>NIP</strong> | Password: <strong>NIP</strong></li>
        <li><span class="badge">Wali Murid</span> Username: <strong>NISN</strong> | Password: <strong>NISN</strong></li>
      </ul>
    </div>

    <!-- Login Form -->
    <form method="post" action="cek.php" id="loginForm">
      <!-- Input Hidden untuk Role -->
      <input type="hidden" name="selected_role" id="selected_role" value="siswa">
      
      <div class="form-group">
        <label class="form-label">
          <i class="fas fa-user"></i>
          Username
        </label>
        <input type="text" name="username" class="form-input" placeholder="Masukkan NISN siswa" required>
      </div>
      
      <div class="form-group">
        <label class="form-label">
          <i class="fas fa-lock"></i>
          Password
        </label>
        <input type="password" name="password" class="form-input" placeholder="Masukkan password" required>
      </div>

      <button type="submit" class="btn btn-primary">
        <i class="fas fa-sign-in-alt"></i>
        Masuk ke Sistem
      </button>
    </form>

    <!-- Footer Links -->
    <div class="footer-links">
      <a href="tentang.html">
        <i class="fas fa-info-circle"></i>
        Tentang
      </a>
      <a href="https://shopee.co.id/search?keyword=viralytics">
        <i class="fas fa-phone"></i>
        Kontak
      </a>
      <a href="https://shopee.co.id/search?keyword=viralytics">
        <i class="fas fa-download"></i>
        Unduh
      </a>
      <div class="app-version">Versi 4.00 | 3 Role System | &copy; <?php echo date('Y'); ?></div>
    </div>
  </div>

  <script>
    // Theme Toggle
    function toggleTheme() {
      document.documentElement.classList.toggle('dark');
      const icon = document.querySelector('.theme-toggle i');
      if (document.documentElement.classList.contains('dark')) {
        icon.className = 'fas fa-sun';
        localStorage.setItem('theme', 'dark');
      } else {
        icon.className = 'fas fa-moon';
        localStorage.setItem('theme', 'light');
      }
    }

    // Role Selection
    function selectRole(role) {
      document.querySelectorAll('.role-option').forEach(option => {
        option.classList.remove('active');
      });
      event.currentTarget.classList.add('active');
      
      // Update placeholder dan input hidden berdasarkan role
      const usernameInput = document.querySelector('input[name="username"]');
      const roleInput = document.querySelector('#selected_role');
      
      switch(role) {
        case 'admin':
          usernameInput.placeholder = 'Masukkan username admin';
          roleInput.value = 'admin';
          break;
        case 'wali_kelas':
          usernameInput.placeholder = 'Masukkan NIP wali kelas';
          roleInput.value = 'wali_kelas';
          break;
        case 'siswa':
        default:
          usernameInput.placeholder = 'Masukkan NISN siswa';
          roleInput.value = 'siswa';
      }
      
      // Add subtle animation to selected role
      event.currentTarget.style.animation = 'pulse 0.3s ease';
      setTimeout(() => {
        event.currentTarget.style.animation = '';
      }, 300);
    }

    // Load saved theme
    const savedTheme = localStorage.getItem('theme');
    if (savedTheme === 'dark') {
      document.documentElement.classList.add('dark');
      document.querySelector('.theme-toggle i').className = 'fas fa-sun';
    }

    // Add focus animation to form inputs
    document.querySelectorAll('.form-input').forEach(input => {
      input.addEventListener('focus', function() {
        this.parentElement.style.transform = 'translateY(-2px)';
      });
      
      input.addEventListener('blur', function() {
        this.parentElement.style.transform = 'translateY(0)';
      });
    });

    // Add loading animation to button
    document.querySelector('form').addEventListener('submit', function(e) {
      const button = this.querySelector('.btn-primary');
      const originalText = button.innerHTML;
      button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Memproses...';
      button.disabled = true;
      
      setTimeout(() => {
        button.innerHTML = originalText;
        button.disabled = false;
      }, 2000);
    });

    // Validasi form sebelum submit
    document.getElementById('loginForm').addEventListener('submit', function(e) {
      const username = document.querySelector('input[name="username"]').value;
      const selectedRole = document.querySelector('#selected_role').value;
      
      // Validasi berdasarkan role
      switch(selectedRole) {
        case 'admin':
          if (username !== 'admin') {
            e.preventDefault();
            alert('Untuk login sebagai Admin, username harus "admin"');
            return false;
          }
          break;
        case 'wali_kelas':
          // Validasi NIP (harus angka)
          if (!/^\d+$/.test(username)) {
            e.preventDefault();
            alert('Untuk login sebagai Wali Kelas, username harus berupa NIP (angka)');
            return false;
          }
          break;
        case 'siswa':
          // Validasi NISN (harus angka, 10 digit)
          if (!/^\d{10}$/.test(username)) {
            e.preventDefault();
            alert('Untuk login sebagai Wali Murid, username harus berupa NISN (10 digit angka)');
            return false;
          }
          break;
      }
    });

    // Auto-focus pada username field
    document.addEventListener('DOMContentLoaded', function() {
      document.querySelector('input[name="username"]').focus();
    });
  </script>
</body>
</html>