<?php
session_start();
include 'config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header("Location: index.php");
    exit;
}

if (!isset($_SESSION['siswa_id'])) {
    die("Data siswa tidak ditemukan, silakan login ulang.");
}

$siswa_id = intval($_SESSION['siswa_id']);
$username = $_SESSION['username'];

// Ambil data siswa
$q = mysqli_query($conn, "SELECT nama, kelas FROM siswa WHERE id = $siswa_id");
if (!$q) {
    die("Error: " . mysqli_error($conn));
}
$siswa = mysqli_fetch_assoc($q);

// Filter bulan & tahun (default bulan & tahun ini)
$bulanFilter = isset($_GET['bulan']) ? $_GET['bulan'] : date("m");
$tahunFilter = isset($_GET['tahun']) ? $_GET['tahun'] : date("Y");

// Ambil riwayat absensi sesuai filter
$qAbsensi = mysqli_query($conn, "
    SELECT tanggal, jam, status 
    FROM absensi 
    WHERE siswa_id = $siswa_id
      AND MONTH(tanggal) = '" . mysqli_real_escape_string($conn, $bulanFilter) . "'
      AND YEAR(tanggal) = '" . mysqli_real_escape_string($conn, $tahunFilter) . "'
    ORDER BY tanggal DESC, jam DESC
");
?>
<!DOCTYPE html>
<html lang="id" class="dark">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Kehadiran Siswa - Sistem Absensi QR</title>
  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #6366f1;
      --primary-dark: #4f46e5;
      --primary-light: #8b5cf6;
      --secondary: #ec4899;
      --accent: #f59e0b;
      --success: #10b981;
      --warning: #f59e0b;
      --danger: #ef4444;
      --info: #3b82f6;
      --dark: #1f2937;
      --darker: #111827;
      --light: #f8fafc;
      --gray: #6b7280;
      --gray-light: #e5e7eb;
      --card-bg: #ffffff;
      --card-bg-dark: #374151;
      --text-primary: #1f2937;
      --text-primary-dark: #f9fafb;
      --text-secondary: #6b7280;
      --text-secondary-dark: #d1d5db;
      --border-radius: 16px;
      --shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
      --shadow-hover: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
      --shadow-dark: 0 10px 25px -5px rgba(0, 0, 0, 0.3), 0 8px 10px -6px rgba(0, 0, 0, 0.2);
      --gradient-primary: linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%);
      --gradient-accent: linear-gradient(135deg, #ec4899 0%, #f59e0b 100%);
      --gradient-success: linear-gradient(135deg, #10b981 0%, #059669 100%);
      --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .dark {
      --card-bg: var(--card-bg-dark);
      --text-primary: var(--text-primary-dark);
      --text-secondary: var(--text-secondary-dark);
      --shadow: var(--shadow-dark);
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: 'Inter', sans-serif;
      background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
      min-height: 100vh;
      color: var(--text-primary);
      line-height: 1.6;
      transition: var(--transition);
    }

    .dark body {
      background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
    }

    /* Header Styles */
    .header {
      background: var(--gradient-primary);
      color: white;
      padding: 1.5rem 2rem;
      box-shadow: var(--shadow);
      position: relative;
      overflow: hidden;
    }

    .header::before {
      content: '';
      position: absolute;
      top: -50%;
      right: -10%;
      width: 300px;
      height: 300px;
      background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
      border-radius: 50%;
    }

    .header-content {
      position: relative;
      z-index: 2;
      max-width: 1400px;
      margin: 0 auto;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .logo-section h1 {
      font-size: 1.75rem;
      font-weight: 700;
      margin-bottom: 0.25rem;
    }

    .logo-section .subtitle {
      font-size: 0.9rem;
      opacity: 0.9;
      font-weight: 400;
    }

    .user-info {
      background: rgba(255, 255, 255, 0.15);
      padding: 0.75rem 1.5rem;
      border-radius: var(--border-radius);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.2);
      display: flex;
      align-items: center;
      gap: 1rem;
    }

    .user-avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.2);
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 1.2rem;
    }

    .user-details .welcome {
      font-weight: 500;
      margin-bottom: 0.25rem;
    }

    .user-details .role {
      font-size: 0.85rem;
      opacity: 0.8;
    }

    /* Theme Toggle */
    .theme-toggle {
      background: rgba(255, 255, 255, 0.15);
      border: 1px solid rgba(255, 255, 255, 0.2);
      color: white;
      padding: 0.5rem;
      border-radius: 50%;
      cursor: pointer;
      transition: var(--transition);
      backdrop-filter: blur(10px);
    }

    .theme-toggle:hover {
      background: rgba(255, 255, 255, 0.25);
      transform: rotate(45deg);
    }

    /* Main Content */
    .dashboard-container {
      max-width: 1400px;
      margin: 0 auto;
      padding: 2rem;
    }

    .section-title {
      font-size: 1.5rem;
      font-weight: 600;
      color: var(--text-primary);
      margin-bottom: 1.5rem;
      position: relative;
    }

    .section-title::after {
      content: '';
      display: block;
      width: 60px;
      height: 3px;
      background: var(--primary);
      margin: 0.5rem 0;
      border-radius: 2px;
    }

    /* Back Button */
    .back-button {
      display: inline-flex;
      align-items: center;
      gap: 0.5rem;
      padding: 0.75rem 1.5rem;
      background: var(--primary);
      color: white;
      text-decoration: none;
      border-radius: 8px;
      font-weight: 500;
      transition: var(--transition);
      margin-bottom: 2rem;
    }

    .back-button:hover {
      background: var(--primary-dark);
      transform: translateY(-2px);
    }

    /* Filter Section */
    .filter-section {
      background: var(--card-bg);
      border-radius: var(--border-radius);
      padding: 1.5rem;
      box-shadow: var(--shadow);
      margin-bottom: 2rem;
      border: 1px solid rgba(0,0,0,0.05);
    }

    .dark .filter-section {
      border: 1px solid rgba(255,255,255,0.1);
    }

    .filter-form {
      display: flex;
      gap: 1rem;
      align-items: end;
      flex-wrap: wrap;
    }

    .form-group {
      display: flex;
      flex-direction: column;
      min-width: 150px;
    }

    .form-label {
      font-weight: 500;
      margin-bottom: 0.5rem;
      color: var(--text-primary);
      font-size: 0.9rem;
    }

    .form-select {
      padding: 0.75rem;
      border: 1px solid var(--gray-light);
      border-radius: 8px;
      background: var(--card-bg);
      color: var(--text-primary);
      font-size: 0.9rem;
      transition: var(--transition);
    }

    .dark .form-select {
      border-color: rgba(255,255,255,0.2);
      background: var(--card-bg-dark);
    }

    .form-select:focus {
      outline: none;
      border-color: var(--primary);
      box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
    }

    .btn {
      padding: 0.75rem 1.5rem;
      border: none;
      border-radius: 8px;
      font-weight: 500;
      cursor: pointer;
      transition: var(--transition);
      display: inline-flex;
      align-items: center;
      justify-content: center;
      gap: 0.5rem;
    }

    .btn-primary {
      background: var(--primary);
      color: white;
    }

    .btn-primary:hover {
      background: var(--primary-dark);
      transform: translateY(-2px);
    }

    /* Table Styles */
    .table-container {
      background: var(--card-bg);
      border-radius: var(--border-radius);
      box-shadow: var(--shadow);
      overflow: hidden;
      border: 1px solid rgba(0,0,0,0.05);
    }

    .dark .table-container {
      border: 1px solid rgba(255,255,255,0.1);
    }

    .table {
      width: 100%;
      border-collapse: collapse;
    }

    .table th {
      background: var(--primary);
      color: white;
      padding: 1rem;
      text-align: left;
      font-weight: 600;
      font-size: 0.9rem;
    }

    .table td {
      padding: 1rem;
      border-bottom: 1px solid var(--gray-light);
      color: var(--text-primary);
    }

    .dark .table td {
      border-bottom: 1px solid rgba(255,255,255,0.1);
    }

    .table tbody tr:hover {
      background: rgba(99, 102, 241, 0.05);
    }

    .dark .table tbody tr:hover {
      background: rgba(99, 102, 241, 0.1);
    }

    .status-badge {
      padding: 0.25rem 0.75rem;
      border-radius: 20px;
      font-size: 0.8rem;
      font-weight: 500;
    }

    .status-hadir { background: #dcfce7; color: #166534; }
    .status-sakit { background: #fef3c7; color: #92400e; }
    .status-izin { background: #dbeafe; color: #1e40af; }
    .status-alpha { background: #fee2e2; color: #991b1b; }

    .dark .status-hadir { background: #166534; color: #dcfce7; }
    .dark .status-sakit { background: #92400e; color: #fef3c7; }
    .dark .status-izin { background: #1e40af; color: #dbeafe; }
    .dark .status-alpha { background: #991b1b; color: #fee2e2; }

    /* Footer */
    .footer {
      background: var(--dark);
      color: white;
      text-align: center;
      padding: 1.5rem;
      margin-top: 3rem;
    }

    .footer-content {
      max-width: 1400px;
      margin: 0 auto;
    }

    .version {
      font-size: 0.875rem;
      opacity: 0.8;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
      .header-content {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
      }

      .user-info {
        width: 100%;
        max-width: 300px;
      }

      .dashboard-container {
        padding: 1.5rem;
      }

      .filter-form {
        flex-direction: column;
        align-items: stretch;
      }

      .form-group {
        min-width: auto;
      }
    }

    @media (max-width: 480px) {
      .header {
        padding: 1rem;
      }

      .dashboard-container {
        padding: 1rem;
      }

      .table {
        font-size: 0.8rem;
      }

      .table th,
      .table td {
        padding: 0.75rem 0.5rem;
      }
    }

    /* Loading Animation */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .fade-in-up {
      animation: fadeInUp 0.6s ease-out;
    }

    .empty-state {
      text-align: center;
      padding: 3rem;
      color: var(--text-secondary);
    }

    .empty-state i {
      font-size: 3rem;
      margin-bottom: 1rem;
      opacity: 0.5;
    }
  </style>
</head>
<body>
  <!-- Header -->
  <header class="header">
    <div class="header-content">
      <div class="logo-section">
        <h1>Kehadiran Siswa</h1>
        <div class="subtitle">Sistem Absensi QR Modern</div>
      </div>
      <div class="user-info">
        <div class="user-avatar">
          <i class="fas fa-user-graduate"></i>
        </div>
        <div class="user-details">
          <div class="welcome">Halo, <?php echo htmlspecialchars($siswa['nama']); ?></div>
          <div class="role"><?php echo htmlspecialchars($siswa['kelas']); ?></div>
        </div>
        <button class="theme-toggle" onclick="toggleTheme()">
          <i class="fas fa-moon"></i>
        </button>
      </div>
    </div>
  </header>

  <!-- Main Content -->
  <div class="dashboard-container">
    <!-- Back Button -->
    <a href="dashboard_siswa.php" class="back-button fade-in-up">
      <i class="fas fa-arrow-left"></i>
      Kembali ke Dashboard
    </a>

    <h2 class="section-title">Riwayat Kehadiran</h2>

    <!-- Filter Section -->
    <div class="filter-section fade-in-up">
      <form method="GET" class="filter-form">
        <div class="form-group">
          <label class="form-label">Bulan</label>
          <select name="bulan" class="form-select">
            <?php 
            $namaBulan = [
                1=>"Januari", 2=>"Februari", 3=>"Maret", 4=>"April",
                5=>"Mei", 6=>"Juni", 7=>"Juli", 8=>"Agustus",
                9=>"September", 10=>"Oktober", 11=>"November", 12=>"Desember"
            ];
            foreach ($namaBulan as $num => $nama) {
                $selected = ($bulanFilter == $num) ? "selected" : "";
                echo "<option value='$num' $selected>$nama</option>";
            }
            ?>
          </select>
        </div>
        <div class="form-group">
          <label class="form-label">Tahun</label>
          <select name="tahun" class="form-select">
            <?php
            $tahunSekarang = date("Y");
            for ($t = $tahunSekarang; $t >= $tahunSekarang - 5; $t--) {
                $selected = ($tahunFilter == $t) ? "selected" : "";
                echo "<option value='$t' $selected>$t</option>";
            }
            ?>
          </select>
        </div>
        <div class="form-group">
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-filter"></i>
            Filter
          </button>
        </div>
      </form>
    </div>

    <!-- Table Section -->
    <div class="table-container fade-in-up">
      <table class="table">
        <thead>
          <tr>
            <th>No</th>
            <th>Tanggal</th>
            <th>Jam</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($qAbsensi && mysqli_num_rows($qAbsensi) > 0): ?>
            <?php $no=1; while($row = mysqli_fetch_assoc($qAbsensi)): 
              $statusClass = 'status-' . strtolower($row['status']);
            ?>
              <tr>
                <td><?= $no++ ?></td>
                <td><?= htmlspecialchars($row['tanggal']) ?></td>
                <td><?= htmlspecialchars($row['jam']) ?></td>
                <td>
                  <span class="status-badge <?= $statusClass ?>">
                    <?= htmlspecialchars($row['status']) ?>
                  </span>
                </td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr>
              <td colspan="4" class="empty-state">
                <i class="fas fa-inbox"></i>
                <div>Belum ada data absensi untuk bulan <?php echo $namaBulan[$bulanFilter] . ' ' . $tahunFilter; ?></div>
              </td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>

  <footer class="footer">
    <div class="footer-content">
      <div class="version">Versi Aplikasi: 4.00 | &copy; <?php echo date('Y'); ?> Sistem Absensi QR Modern</div>
    </div>
  </footer>

  <script>
    // Theme Toggle
    function toggleTheme() {
      document.documentElement.classList.toggle('dark');
      const icon = document.querySelector('.theme-toggle i');
      if (document.documentElement.classList.contains('dark')) {
        icon.className = 'fas fa-sun';
        localStorage.setItem('theme', 'dark');
      } else {
        icon.className = 'fas fa-moon';
        localStorage.setItem('theme', 'light');
      }
    }

    // Load saved theme
    const savedTheme = localStorage.getItem('theme');
    if (savedTheme === 'dark') {
      document.documentElement.classList.add('dark');
      document.querySelector('.theme-toggle i').className = 'fas fa-sun';
    }

    // Animation on scroll
    const observerOptions = {
      threshold: 0.1,
      rootMargin: '0px 0px -50px 0px'
    };

    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.style.animation = 'fadeInUp 0.6s ease-out forwards';
          observer.unobserve(entry.target);
        }
      });
    }, observerOptions);

    // Observe all cards for animation
    document.addEventListener('DOMContentLoaded', () => {
      const cards = document.querySelectorAll('.filter-section, .table-container, .back-button');
      cards.forEach(card => {
        observer.observe(card);
      });
    });
  </script>
</body>
</html>