<?php
session_start();
include 'config.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header("Location: index.php");
    exit;
}

if (!isset($_SESSION['siswa_id'])) {
    die("Data siswa tidak ditemukan, silakan login ulang.");
}

$siswa_id = intval($_SESSION['siswa_id']);

// Ambil data siswa
$q = mysqli_query($conn, "SELECT nama, kelas FROM siswa WHERE id = $siswa_id");
if (!$q) {
    die("Error: " . mysqli_error($conn));
}
$siswa = mysqli_fetch_assoc($q);

// Ambil data pelanggaran
$qPelanggaran = mysqli_query($conn, "
    SELECT p.*, g.nama as guru_nama 
    FROM pelanggaran p 
    LEFT JOIN guru g ON p.guru_id = g.id 
    WHERE p.siswa_id = $siswa_id 
    ORDER BY p.tanggal DESC, p.created_at DESC
");

$pelanggaran = [];
$total_poin = 0;
if ($qPelanggaran) {
    while ($row = mysqli_fetch_assoc($qPelanggaran)) {
        $pelanggaran[] = $row;
        $total_poin += $row['poin'] ?? 0;
    }
}
?>

<!DOCTYPE html>
<html lang="id" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pelanggaran Siswa - Sistem Absensi QR</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #6366f1;
            --danger: #ef4444;
            --warning: #f59e0b;
            --card-bg: #ffffff;
            --card-bg-dark: #374151;
            --text-primary: #1f2937;
            --text-primary-dark: #f9fafb;
            --border-radius: 12px;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }

        .dark {
            --card-bg: var(--card-bg-dark);
            --text-primary: var(--text-primary-dark);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: #f8fafc;
            color: var(--text-primary);
            line-height: 1.6;
        }

        .dark body {
            background: #0f172a;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 2rem;
        }

        .header {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            color: white;
            padding: 2rem;
            border-radius: var(--border-radius);
            margin-bottom: 2rem;
            text-align: center;
        }

        .header h1 {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }

        .card {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            padding: 2rem;
            box-shadow: var(--shadow);
            margin-bottom: 2rem;
        }

        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: var(--card-bg);
            border-radius: var(--border-radius);
            padding: 1.5rem;
            box-shadow: var(--shadow);
            text-align: center;
            border-left: 4px solid var(--danger);
        }

        .stat-number {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--danger);
            margin-bottom: 0.5rem;
        }

        .stat-label {
            font-size: 0.9rem;
            color: #6b7280;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }

        .table th,
        .table td {
            padding: 1rem;
            text-align: left;
            border-bottom: 1px solid #e5e7eb;
        }

        .table th {
            background: #f8fafc;
            font-weight: 600;
        }

        .dark .table th {
            background: #374151;
        }

        .badge {
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.875rem;
            font-weight: 500;
        }

        .badge-warning {
            background: #fef3c7;
            color: #d97706;
        }

        .badge-danger {
            background: #fee2e2;
            color: #dc2626;
        }

        .badge-success {
            background: #d1fae5;
            color: #059669;
        }

        .back-btn {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: #6b7280;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            margin-bottom: 2rem;
            transition: background 0.3s;
        }

        .back-btn:hover {
            background: #4b5563;
        }

        .empty-state {
            text-align: center;
            color: #6b7280;
            padding: 3rem;
        }

        .empty-state i {
            font-size: 4rem;
            margin-bottom: 1rem;
            opacity: 0.5;
        }

        .poin-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-top: 1rem;
        }

        .poin-item {
            padding: 1rem;
            border-radius: 8px;
            text-align: center;
            border: 2px solid #e5e7eb;
        }

        .dark .poin-item {
            border-color: #4b5563;
        }

        .poin-item strong {
            display: block;
            margin-bottom: 0.5rem;
            color: var(--text-primary);
        }

        .poin-item span {
            color: var(--text-primary);
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="dashboard_siswa.php" class="back-btn">
            <i class="fas fa-arrow-left"></i> Kembali ke Dashboard
        </a>

        <div class="header">
            <h1><i class="fas fa-exclamation-triangle"></i> Data Pelanggaran</h1>
            <p>Lihat riwayat pelanggaran dan poin yang tercatat</p>
        </div>

        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-number"><?php echo count($pelanggaran); ?></div>
                <div class="stat-label">Total Pelanggaran</div>
            </div>
            <div class="stat-card">
                <div class="stat-number"><?php echo $total_poin; ?></div>
                <div class="stat-label">Total Poin Pelanggaran</div>
            </div>
        </div>

        <div class="card">
            <h2 style="margin-bottom: 1.5rem;"><i class="fas fa-list"></i> Riwayat Pelanggaran</h2>
            
            <?php if (empty($pelanggaran)): ?>
                <div class="empty-state">
                    <i class="fas fa-check-circle"></i>
                    <h3>Tidak Ada Pelanggaran</h3>
                    <p>Anda tidak memiliki catatan pelanggaran. Pertahankan kedisiplinan!</p>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Tanggal</th>
                                <th>Jenis Pelanggaran</th>
                                <th>Keterangan</th>
                                <th>Poin</th>
                                <th>Ditambah oleh</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($pelanggaran as $data): ?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($data['tanggal'])); ?></td>
                                    <td><?php echo htmlspecialchars($data['jenis_pelanggaran']); ?></td>
                                    <td><?php echo htmlspecialchars($data['keterangan']); ?></td>
                                    <td>
                                        <span class="badge <?php echo $data['poin'] >= 10 ? 'badge-danger' : 'badge-warning'; ?>">
                                            <?php echo $data['poin']; ?> Poin
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($data['guru_nama'] ?? 'System'); ?></td>
                                    <td>
                                        <span class="badge <?php echo $data['status'] === 'Selesai' ? 'badge-success' : 'badge-warning'; ?>">
                                            <?php echo ucfirst($data['status']); ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>

        <div class="card">
            <h3 style="margin-bottom: 1rem; color: var(--danger);">
                <i class="fas fa-info-circle"></i> Informasi Poin Pelanggaran
            </h3>
            <div class="poin-info">
                <div class="poin-item">
                    <strong>1-5 Poin</strong>
                    <span>Peringatan Ringan</span>
                </div>
                <div class="poin-item">
                    <strong>6-10 Poin</strong>
                    <span>Peringatan Sedang</span>
                </div>
                <div class="poin-item">
                    <strong>11-15 Poin</strong>
                    <span>Peringatan Berat</span>
                </div>
                <div class="poin-item">
                    <strong>>15 Poin</strong>
                    <span>Sanksi Akademik</span>
                </div>
            </div>
        </div>
    </div>
</body>
</html>