<?php
include 'config.php';

$kelas = $_GET['kelas'] ?? '';
$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');

// Dapatkan tanggal hari ini untuk perbandingan
$hariIni = date('d');
$bulanIni = date('m');
$tahunIni = date('Y');

$kelasList = mysqli_query($conn, "SELECT DISTINCT kelas FROM siswa ORDER BY kelas");
$jumlahHari = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);

// Ambil siswa hanya yang aktif
$siswaQuery = "SELECT * FROM siswa WHERE status='aktif'";
if ($kelas != '') {
  $siswaQuery .= " AND kelas = '$kelas'";
}
$siswaQuery .= " ORDER BY nama";
$siswaResult = mysqli_query($conn, $siswaQuery);

// Ambil data absensi hanya siswa aktif
$absensi = [];
$absensiQuery = "SELECT a.*, s.nis, s.nama FROM absensi a 
                 JOIN siswa s ON a.siswa_id = s.id 
                 WHERE MONTH(a.tanggal) = '$bulan' 
                   AND YEAR(a.tanggal) = '$tahun'
                   AND s.status='aktif'";
if ($kelas != '') {
  $absensiQuery .= " AND s.kelas = '$kelas'";
}
$resultAbsensi = mysqli_query($conn, $absensiQuery);

while ($row = mysqli_fetch_assoc($resultAbsensi)) {
  $sid = $row['siswa_id'];
  $tgl = (int)date('j', strtotime($row['tanggal']));
  $absensi[$sid][$tgl] = $row['status'];
}

// AMBIL DATA PERIZINAN YANG SUDAH DISETUJUI
$perizinan = [];
$izinQuery = "SELECT p.*, s.id as siswa_id, s.nis, s.nama 
              FROM perizinan p 
              JOIN siswa s ON p.siswa_id = s.id 
              WHERE MONTH(p.tanggal_izin) = '$bulan' 
                AND YEAR(p.tanggal_izin) = '$tahun'
                AND p.status = 'approved'
                AND s.status='aktif'";
if ($kelas != '') {
  $izinQuery .= " AND s.kelas = '$kelas'";
}
$resultIzin = mysqli_query($conn, $izinQuery);

while ($row = mysqli_fetch_assoc($resultIzin)) {
  $sid = $row['siswa_id'];
  $tgl = (int)date('j', strtotime($row['tanggal_izin']));
  // Tentukan status berdasarkan jenis izin
  $status = ($row['jenis_izin'] == 'Sakit') ? 'S' : 'I';
  $perizinan[$sid][$tgl] = $status;
}

// Ambil daftar hari libur dari database
$libur = [];
$queryLibur = mysqli_query($conn, "SELECT tanggal FROM hari_libur");
while ($row = mysqli_fetch_assoc($queryLibur)) {
  $libur[] = $row['tanggal'];
}

// Ambil data profil sekolah
$profil = mysqli_fetch_assoc(mysqli_query($conn, "SELECT kepala_sekolah, nip_kepala FROM profil_sekolah LIMIT 1"));

// Ambil data wali kelas
$wali_nama = '....................................';
$wali_nip = '........................';
if ($kelas != '') {
    $qWali = mysqli_query($conn, "SELECT nama_wali, nip_wali FROM wali_kelas WHERE kelas = '$kelas' LIMIT 1");
    if ($w = mysqli_fetch_assoc($qWali)) {
        $wali_nama = $w['nama_wali'];
        $wali_nip = $w['nip_wali'];
    }
}

// Tanggal terakhir bulan ini
$tanggal_terakhir = date("j F Y", strtotime("$tahun-$bulan-" . cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun)));
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Rekap Absensi Bulanan Per Siswa</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: sans-serif; padding: 20px; }
    table { border-collapse: collapse; width: 100%; font-size: 12px; }
    th, td { border: 1px solid #000; text-align: center; padding: 3px; }
    select, button { padding: 5px; margin: 5px 0; }
    thead th { background: #eee; }
    .minggu { color: red; }
    .dot-red { color: red; font-weight: bold; }
    .alpa { color: red; font-weight: bold; }
    .sakit { color: blue; font-weight: bold; }
    .izin { color: orange; font-weight: bold; }
    .libur { background-color: #fff0f0; }
    .hari-mendatang { background-color: #f9f9f9; color: #ccc; }
    .legend { margin: 10px 0; padding: 10px; background: #f8f9fa; border-radius: 5px; }
    .legend-item { display: inline-block; margin-right: 15px; }
  </style>
</head>
<body>
  <h2>Rekap Absensi Bulanan Per Siswa</h2>

  <!-- Legend -->
  <div class="legend">
    <strong>Keterangan: </strong>
    <span class="legend-item">• = Hadir</span>
    <span class="legend-item"><span class="sakit">S = Sakit</span></span>
    <span class="legend-item"><span class="izin">I = Izin</span></span>
    <span class="legend-item"><span class="alpa">A = Alpha</span></span>
    <span class="legend-item"><span class="dot-red">• = Libur/Minggu</span></span>
  </div>

  <form method="get">
    <label>Kelas:
      <select name="kelas">
        <option value="">Semua</option>
        <?php 
        mysqli_data_seek($kelasList, 0);
        while ($k = mysqli_fetch_assoc($kelasList)) {
          $sel = ($k['kelas'] == $kelas) ? 'selected' : '';
          echo "<option value='{$k['kelas']}' $sel>{$k['kelas']}</option>";
        } ?>
      </select>
    </label>

    <label>Bulan:
      <select name="bulan">
        <?php for ($b = 1; $b <= 12; $b++) {
          $sel = ($b == $bulan) ? 'selected' : '';
          echo "<option value='$b' $sel>" . date('F', mktime(0, 0, 0, $b, 10)) . "</option>";
        } ?>
      </select>
    </label>

    <label>Tahun:
      <input type="number" name="tahun" value="<?= $tahun ?>" style="width: 80px;">
    </label>

    <button type="submit">Tampilkan</button>
    <a href="cetak_absen.php?kelas=<?= $kelas ?>&bulan=<?= $bulan ?>&tahun=<?= $tahun ?>" target="_blank" style="padding:5px 10px; background:#28a745; color:#fff; text-decoration:none; border-radius:4px;">Cetak / Simpan PDF</a>
    <a href="dashboard.php" style="padding:5px 10px; background:#6c757d; color:#fff; text-decoration:none; border-radius:4px;">⬅ Kembali ke Dashboard</a>
  </form>

  <table>
    <thead>
      <tr>
        <th rowspan="2">No</th>
        <th rowspan="2">NIS</th>
        <th rowspan="2">Nama</th>
        <th colspan="<?= $jumlahHari ?>">Tanggal</th>
        <th colspan="4">Rekap</th>
      </tr>
      <tr>
        <?php
        for ($i = 1; $i <= $jumlahHari; $i++) {
          $tanggal = "$tahun-" . str_pad($bulan, 2, '0', STR_PAD_LEFT) . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
          $day = date('w', strtotime($tanggal)); // 0 = Minggu
          $class = ($day == 0) ? 'minggu' : '';
          echo "<th class='$class'>$i</th>";
        }
        ?>
        <th>H</th><th>S</th><th>I</th><th>A</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $no = 1;
      // Reset pointer untuk mengulang query siswa
      mysqli_data_seek($siswaResult, 0);
      while ($siswa = mysqli_fetch_assoc($siswaResult)) {
        $sid = $siswa['id'];
        echo "<tr>";
        echo "<td>$no</td>";
        echo "<td>{$siswa['nis']}</td>";
        echo "<td>{$siswa['nama']}</td>";

        $countH = $countS = $countI = $countA = 0;

        for ($i = 1; $i <= $jumlahHari; $i++) {
          $tanggal = "$tahun-" . str_pad($bulan, 2, '0', STR_PAD_LEFT) . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
          $day = date('w', strtotime($tanggal));
          $isLibur = in_array($tanggal, $libur);
          
          // Tentukan apakah hari ini adalah hari mendatang
          $isHariMendatang = false;
          if ($tahun == $tahunIni && $bulan == $bulanIni && $i > $hariIni) {
            $isHariMendatang = true;
          } elseif ($tahun == $tahunIni && $bulan > $bulanIni) {
            $isHariMendatang = true;
          } elseif ($tahun > $tahunIni) {
            $isHariMendatang = true;
          }
          
          // CEK DATA PERIZINAN TERLEBIH DAHULU (jika ada izin yang disetujui)
          $izinVal = $perizinan[$sid][$i] ?? '';
          $absensiVal = $absensi[$sid][$i] ?? '';
          
          if ($izinVal != '') {
            // Jika ada izin yang disetujui, tampilkan status izin
            if ($izinVal == 'S') {
              echo "<td class='sakit'>S</td>";
              $countS++;
            } elseif ($izinVal == 'I') {
              echo "<td class='izin'>I</td>";
              $countI++;
            } else {
              echo "<td>$izinVal</td>";
            }
          }
          // Jika tidak ada izin, cek data absensi biasa
          elseif ($absensiVal == '') {
            // Jika hari Minggu atau libur, tandai dengan simbol khusus
            if ($day == 0 || $isLibur) {
              echo "<td class='libur'><span class='dot-red'>&bull;</span></td>";
            } 
            // Jika hari mendatang, kosongkan
            elseif ($isHariMendatang) {
              echo "<td class='hari-mendatang'></td>";
            }
            // Jika hari kerja yang sudah lewat tanpa data absensi = Alpha
            else {
              echo "<td class='alpa'>A</td>";
              $countA++;
            }
          } else {
            if ($absensiVal == 'H') {
              echo "<td>&bull;</td>";
              $countH++;
            } elseif ($absensiVal == 'A') {
              echo "<td class='alpa'>A</td>";
              $countA++;
            } elseif ($absensiVal == 'S') {
              echo "<td class='sakit'>S</td>";
              $countS++;
            } elseif ($absensiVal == 'I') {
              echo "<td class='izin'>I</td>";
              $countI++;
            } else {
              echo "<td>$absensiVal</td>";
            }
          }
        }

        echo "<td>$countH</td><td>$countS</td><td>$countI</td><td>$countA</td>";
        echo "</tr>";
        $no++;
      }
      ?>
    </tbody>
  </table>

  <br><br>
  <table style="width:100%; border:0; font-size:14px; text-align:center;">
    <tr>
      <td style="width:50%;">
        Mengetahui,<br>
        Kepala Sekolah<br><br><br><br>
        <u><?= $profil['kepala_sekolah'] ?? '....................................' ?></u><br>
        NIP. <?= $profil['nip_kepala'] ?? '........................' ?>
      </td>
      <td style="width:50%;">
        <?= $tanggal_terakhir ?><br>
        Wali Kelas <?= $kelas != '' ? $kelas : '(Semua Kelas)' ?><br><br><br><br>
        <u><?= $wali_nama ?></u><br>
        NIP. <?= $wali_nip ?>
      </td>
    </tr>
  </table>

  <div style="margin-top: 20px; padding: 10px; background: #f8f9fa; border-radius: 5px;">
    <strong>Catatan:</strong>
    <ul style="margin: 5px 0; padding-left: 20px;">
      <li>Status <strong>S (Sakit)</strong> ditampilkan jika wali kelas menyetujui izin dengan jenis "Sakit"</li>
      <li>Status <strong>I (Izin)</strong> ditampilkan jika wali kelas menyetujui izin dengan jenis selain "Sakit"</li>
      <li>Status izin hanya muncul jika sudah disetujui oleh wali kelas melalui menu "Daftar Ajuan Izin"</li>
    </ul>
  </div>
</body>
</html>