<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'wali_kelas') {
    header("Location: index.php");
    exit;
}

include 'config.php';

// Ambil kelas yang diampu oleh wali kelas
$username = $_SESSION['username'];
$wali_kelas = mysqli_fetch_assoc(mysqli_query($conn, "SELECT kelas FROM wali_kelas WHERE nip_wali='$username' LIMIT 1"));
$kelas_diampu = $wali_kelas['kelas'] ?? '';

if (empty($kelas_diampu)) {
    die("<script>alert('Anda tidak memiliki kelas yang diampu!'); window.location='dashboard_wali_kelas.php';</script>");
}

$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');

// Tanggal hari ini
$today = date('Y-m-d');
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Rekap Absensi Kelas <?php echo $kelas_diampu; ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    body { font-family: sans-serif; padding: 20px; }
    table { width: 100%; border-collapse: collapse; margin-top: 10px; }
    th, td { padding: 5px; border: 1px solid #000; font-size: 14px; text-align: center; }
    select, button { padding: 5px; }
    .btn-back { 
        padding: 5px 10px; 
        background: #6c757d; 
        color: #fff; 
        text-decoration: none; 
        border-radius: 4px; 
        margin-left: 10px;
    }
    .btn-print { 
        padding: 5px 10px; 
        background: #28a745; 
        color: #fff; 
        text-decoration: none; 
        border-radius: 4px; 
        margin-left: 5px;
    }
    .status-H { color: green; font-weight: bold; }
    .status-A { color: red; font-weight: bold; }
    .status-I { color: orange; font-weight: bold; }
    .status-S { color: blue; font-weight: bold; }
    .future-date { background-color: #f8f9fa; color: #6c757d; }
    .today-cell { background-color: #fff3cd !important; }
  </style>
</head>
<body>
  <h2>Rekap Absensi Bulanan - Kelas <?php echo $kelas_diampu; ?></h2>
  
  <div style="margin-bottom: 15px;">
    <a href="dashboard_wali_kelas.php" class="btn-back">⬅ Kembali</a>
  </div>

  <form method="get">
    <label>Bulan:
      <select name="bulan">
        <?php for ($b = 1; $b <= 12; $b++) {
          $sel = ($b == $bulan) ? 'selected' : '';
          echo "<option $sel value='$b'>" . date('F', mktime(0, 0, 0, $b, 10)) . "</option>";
        } ?>
      </select>
    </label>

    <label>Tahun:
      <input type="number" name="tahun" value="<?= $tahun ?>" style="width:80px;">
    </label>

    <button type="submit">Tampilkan</button>
    <a href="cetak_absen.php?kelas=<?= $kelas_diampu ?>&bulan=<?= $bulan ?>&tahun=<?= $tahun ?>" target="_blank" class="btn-print">Cetak PDF</a>
  </form>

  <?php
  // Query untuk mendapatkan semua siswa di kelas
  $query_siswa = "SELECT id, nis, nisn, nama, kelas FROM siswa WHERE kelas = '$kelas_diampu' AND status = 'aktif' ORDER BY nama";
  $result_siswa = mysqli_query($conn, $query_siswa);
  $siswa_list = [];
  while ($siswa = mysqli_fetch_assoc($result_siswa)) {
      $siswa_list[$siswa['id']] = $siswa;
  }

  // Hitung jumlah hari dalam bulan
  $days_in_month = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);
  
  // Buat array tanggal yang akan ditampilkan (semua tanggal dalam bulan)
  $dates = [];
  for ($day = 1; $day <= $days_in_month; $day++) {
      $dates[] = date('Y-m-d', strtotime("$tahun-$bulan-$day"));
  }

  // Query untuk mendapatkan data absensi dari scan
  $query_absensi = "SELECT a.siswa_id, a.tanggal, a.status, a.keterangan 
                    FROM absensi a 
                    JOIN siswa s ON a.siswa_id = s.id 
                    WHERE MONTH(a.tanggal) = '$bulan' 
                    AND YEAR(a.tanggal) = '$tahun' 
                    AND s.kelas = '$kelas_diampu'";
  $result_absensi = mysqli_query($conn, $query_absensi);
  $absensi_data = [];
  while ($absensi = mysqli_fetch_assoc($result_absensi)) {
      $absensi_data[$absensi['siswa_id']][$absensi['tanggal']] = $absensi;
  }

  // Query untuk mendapatkan data izin yang disetujui
  $query_izin = "SELECT p.siswa_id, p.tanggal_izin, p.jenis_izin, p.keterangan 
                 FROM perizinan p 
                 JOIN siswa s ON p.siswa_id = s.id 
                 WHERE MONTH(p.tanggal_izin) = '$bulan' 
                 AND YEAR(p.tanggal_izin) = '$tahun' 
                 AND s.kelas = '$kelas_diampu' 
                 AND p.status = 'approved'";
  $result_izin = mysqli_query($conn, $query_izin);
  $izin_data = [];
  while ($izin = mysqli_fetch_assoc($result_izin)) {
      $izin_data[$izin['siswa_id']][$izin['tanggal_izin']] = $izin;
  }

  // Hitung rekap per siswa (hanya untuk tanggal yang sudah lewat)
  $rekap_siswa = [];
  foreach ($siswa_list as $siswa_id => $siswa) {
      $rekap_siswa[$siswa_id] = [
          'siswa' => $siswa,
          'hadir' => 0,
          'sakit' => 0,
          'izin' => 0,
          'alpha' => 0
      ];
      
      foreach ($dates as $tanggal) {
          $is_future = ($tanggal > $today);
          
          // Jika tanggal masih future, skip (tidak hitung sebagai alpha)
          if ($is_future) {
              continue;
          }
          
          $status = 'A'; // Default Alpha hanya untuk tanggal yang sudah lewat
          
          // Cek apakah ada izin yang disetujui untuk tanggal ini
          if (isset($izin_data[$siswa_id][$tanggal])) {
              $izin = $izin_data[$siswa_id][$tanggal];
              if ($izin['jenis_izin'] == 'Sakit') {
                  $status = 'S';
                  $rekap_siswa[$siswa_id]['sakit']++;
              } else {
                  $status = 'I';
                  $rekap_siswa[$siswa_id]['izin']++;
              }
          }
          // Cek apakah ada absensi dari scan untuk tanggal ini
          elseif (isset($absensi_data[$siswa_id][$tanggal])) {
              $absensi = $absensi_data[$siswa_id][$tanggal];
              $status = $absensi['status'];
              if ($status == 'H') {
                  $rekap_siswa[$siswa_id]['hadir']++;
              } elseif ($status == 'S') {
                  $rekap_siswa[$siswa_id]['sakit']++;
              } elseif ($status == 'I') {
                  $rekap_siswa[$siswa_id]['izin']++;
              }
          } else {
              $rekap_siswa[$siswa_id]['alpha']++;
          }
      }
  }
  ?>

  <!-- Tabel Rekap Per Siswa -->
  <h3 style="margin-top: 30px;">Rekap Per Siswa</h3>
  <table>
    <tr>
      <th>No</th>
      <th>NIS</th>
      <th>NISN</th>
      <th>Nama</th>
      <th>Kelas</th>
      <th>Hadir</th>
      <th>Sakit</th>
      <th>Izin</th>
      <th>Alpha</th>
      <th>Total</th>
    </tr>
    <?php if (!empty($rekap_siswa)): ?>
      <?php 
      $no = 1;
      foreach ($rekap_siswa as $siswa_id => $rekap): 
          $siswa = $rekap['siswa'];
          $total = $rekap['hadir'] + $rekap['sakit'] + $rekap['izin'] + $rekap['alpha'];
      ?>
      <tr>
        <td><?= $no ?></td>
        <td><?= $siswa['nis'] ?></td>
        <td><?= $siswa['nisn'] ?></td>
        <td style="text-align: left;"><?= $siswa['nama'] ?></td>
        <td><?= $siswa['kelas'] ?></td>
        <td class="status-H"><?= $rekap['hadir'] ?></td>
        <td class="status-S"><?= $rekap['sakit'] ?></td>
        <td class="status-I"><?= $rekap['izin'] ?></td>
        <td class="status-A"><?= $rekap['alpha'] ?></td>
        <td><strong><?= $total ?></strong></td>
      </tr>
      <?php $no++; endforeach; ?>
    <?php else: ?>
      <tr><td colspan="10" style="text-align: center;">Tidak ada data siswa untuk kelas <?php echo $kelas_diampu; ?>.</td></tr>
    <?php endif; ?>
  </table>

  <!-- Tabel Detail Harian -->
  <h3 style="margin-top: 30px;">Detail Absensi Harian</h3>
  <div style="overflow-x: auto;">
    <table>
      <tr>
        <th rowspan="2">No</th>
        <th rowspan="2">Nama</th>
        <th colspan="<?= count($dates) ?>">Tanggal (<?= date('F Y', strtotime("$tahun-$bulan-01")) ?>)</th>
      </tr>
      <tr>
        <?php foreach ($dates as $tanggal): 
          $is_today = ($tanggal == $today);
          $day_number = date('d', strtotime($tanggal));
        ?>
          <th style="font-size: 10px; padding: 2px; <?= $is_today ? 'background-color: #fff3cd;' : '' ?>">
            <?= $day_number ?>
          </th>
        <?php endforeach; ?>
      </tr>
      <?php if (!empty($siswa_list)): ?>
        <?php 
        $no_detail = 1;
        foreach ($siswa_list as $siswa_id => $siswa): 
        ?>
        <tr>
          <td><?= $no_detail ?></td>
          <td style="text-align: left; font-size: 12px;"><?= $siswa['nama'] ?></td>
          <?php foreach ($dates as $tanggal): 
            $is_future = ($tanggal > $today);
            $is_today = ($tanggal == $today);
            
            if ($is_future) {
                $status = '';
                $cell_class = 'future-date';
            } else {
                $status = 'A'; // Default Alpha
                
                // Prioritaskan izin yang disetujui
                if (isset($izin_data[$siswa_id][$tanggal])) {
                    $izin = $izin_data[$siswa_id][$tanggal];
                    $status = ($izin['jenis_izin'] == 'Sakit') ? 'S' : 'I';
                }
                // Jika tidak ada izin, cek absensi dari scan
                elseif (isset($absensi_data[$siswa_id][$tanggal])) {
                    $absensi = $absensi_data[$siswa_id][$tanggal];
                    $status = $absensi['status'];
                }
                
                $cell_class = "status-$status";
            }
          ?>
          <td class="<?= $cell_class ?> <?= $is_today ? 'today-cell' : '' ?>" style="font-size: 10px; padding: 2px;">
            <?= $status ?>
          </td>
          <?php endforeach; ?>
        </tr>
        <?php $no_detail++; endforeach; ?>
      <?php else: ?>
        <tr><td colspan="<?= count($dates) + 2 ?>" style="text-align: center;">Tidak ada data siswa untuk kelas <?php echo $kelas_diampu; ?>.</td></tr>
      <?php endif; ?>
    </table>
  </div>

  <div style="margin-top: 15px;">
    <strong>Total Siswa:</strong> <?= count($siswa_list) ?> siswa<br>
    <strong>Periode:</strong> <?= date('F Y', strtotime("$tahun-$bulan-01")) ?> (<?= $days_in_month ?> hari)<br>
    <strong>Hari Ini:</strong> <?= date('d F Y') ?>
  </div>

  <div style="margin-top: 10px; padding: 10px; background-color: #f8f9fa; border-radius: 5px;">
    <strong>Keterangan:</strong><br>
    <span class="status-H">H = Hadir (dari scan QR)</span> | 
    <span class="status-S">S = Sakit (dari izin yang disetujui)</span> | 
    <span class="status-I">I = Izin (dari izin yang disetujui)</span> | 
    <span class="status-A">A = Alpha (tidak hadir dan tidak ada izin)</span><br>
    <span class="future-date">Kosong = Tanggal mendatang</span> | 
    <span style="background-color: #fff3cd;">Kuning = Hari ini</span>
  </div>
</body>
</html>