<?php
session_start();
if (!isset($_SESSION['username']) || $_SESSION['role'] !== 'admin') {
    header("Location: index.php");
    exit;
}

include 'config.php';

// Filter data
$filter_tanggal = isset($_GET['tanggal']) ? $_GET['tanggal'] : '';
$filter_kelas = isset($_GET['kelas']) ? $_GET['kelas'] : '';
$filter_status = isset($_GET['status']) ? $_GET['status'] : '';

// Query data pelanggaran
$query = "SELECT p.*, s.nama as siswa_nama, s.kelas, s.nis, 
                 g.nama as guru_nama, wk.nama_wali as wali_nama
          FROM pelanggaran p 
          JOIN siswa s ON p.siswa_id = s.id 
          LEFT JOIN guru g ON p.guru_id = g.id 
          LEFT JOIN wali_kelas wk ON s.kelas = wk.kelas 
          WHERE 1=1";

$params = [];
if (!empty($filter_tanggal)) {
    $query .= " AND DATE(p.tanggal) = ?";
    $params[] = $filter_tanggal;
}
if (!empty($filter_kelas)) {
    $query .= " AND s.kelas = ?";
    $params[] = $filter_kelas;
}
if (!empty($filter_status)) {
    $query .= " AND p.status = ?";
    $params[] = $filter_status;
}

$query .= " ORDER BY p.tanggal DESC, p.created_at DESC";

// Eksekusi query
$pelanggaran = [];
if (!empty($params)) {
    $stmt = mysqli_prepare($conn, $query);
    if ($stmt) {
        $types = str_repeat('s', count($params));
        mysqli_stmt_bind_param($stmt, $types, ...$params);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        while ($row = mysqli_fetch_assoc($result)) {
            $pelanggaran[] = $row;
        }
    }
} else {
    $result = mysqli_query($conn, $query);
    while ($row = mysqli_fetch_assoc($result)) {
        $pelanggaran[] = $row;
    }
}

// Hitung statistik
$total_pelanggaran = count($pelanggaran);
$total_poin = array_sum(array_column($pelanggaran, 'poin'));

// Query untuk filter kelas
$kelas_query = mysqli_query($conn, "SELECT DISTINCT kelas FROM siswa ORDER BY kelas");
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Riwayat Pelanggaran - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        .table-responsive {
            max-height: 600px;
            overflow-y: auto;
        }
        .badge-warning {
            background: #ffc107;
            color: #000;
        }
        .badge-danger {
            background: #dc3545;
            color: #fff;
        }
        .badge-success {
            background: #28a745;
            color: #fff;
        }
        .stat-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body class="container py-4">
    <h2 class="text-center mb-4"><i class="fas fa-exclamation-triangle"></i> Riwayat Pelanggaran Siswa</h2>

    <a href="dashboard.php" class="btn btn-secondary mb-3">← Kembali ke Dashboard</a>

    <!-- Statistik -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="stat-card">
                <div class="row">
                    <div class="col-8">
                        <h3><?php echo $total_pelanggaran; ?></h3>
                        <p>Total Pelanggaran</p>
                    </div>
                    <div class="col-4 text-end">
                        <i class="fas fa-clipboard-list fa-3x"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="stat-card">
                <div class="row">
                    <div class="col-8">
                        <h3><?php echo $total_poin; ?></h3>
                        <p>Total Poin</p>
                    </div>
                    <div class="col-4 text-end">
                        <i class="fas fa-chart-bar fa-3x"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Form -->
    <div class="card mb-4">
        <div class="card-header bg-light">
            <h5 class="mb-0"><i class="fas fa-filter"></i> Filter Data</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label for="tanggal" class="form-label">Tanggal</label>
                    <input type="date" class="form-control" id="tanggal" name="tanggal" 
                           value="<?php echo $filter_tanggal; ?>">
                </div>
                <div class="col-md-3">
                    <label for="kelas" class="form-label">Kelas</label>
                    <select class="form-control" id="kelas" name="kelas">
                        <option value="">Semua Kelas</option>
                        <?php while($kelas = mysqli_fetch_assoc($kelas_query)): ?>
                            <option value="<?php echo $kelas['kelas']; ?>" 
                                    <?php echo $filter_kelas == $kelas['kelas'] ? 'selected' : ''; ?>>
                                <?php echo $kelas['kelas']; ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="status" class="form-label">Status</label>
                    <select class="form-control" id="status" name="status">
                        <option value="">Semua Status</option>
                        <option value="Aktif" <?php echo $filter_status == 'Aktif' ? 'selected' : ''; ?>>Aktif</option>
                        <option value="Selesai" <?php echo $filter_status == 'Selesai' ? 'selected' : ''; ?>>Selesai</option>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="fas fa-search"></i> Filter
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Tabel Riwayat Pelanggaran -->
    <div class="card">
        <div class="card-header bg-warning text-dark">
            <strong><i class="fas fa-history"></i> Data Pelanggaran</strong>
            <span class="badge bg-dark"><?php echo $total_pelanggaran; ?> Data</span>
        </div>
        <div class="card-body p-0">
            <?php if (empty($pelanggaran)): ?>
                <div class="text-center text-success py-4">
                    <i class="fas fa-check-circle fa-2x mb-2"></i><br>
                    <strong>Tidak ada data pelanggaran</strong>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-bordered table-hover table-sm mb-0">
                        <thead class="table-light">
                            <tr>
                                <th width="5%">No</th>
                                <th width="10%">Tanggal</th>
                                <th width="15%">Siswa</th>
                                <th width="10%">Kelas</th>
                                <th width="15%">Jenis Pelanggaran</th>
                                <th width="20%">Keterangan</th>
                                <th width="5%">Poin</th>
                                <th width="15%">Ditambah Oleh</th>
                                <th width="10%">Status</th>
                                <th width="5%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($pelanggaran as $index => $data): ?>
                                <tr>
                                    <td class="text-center"><?php echo $index + 1; ?></td>
                                    <td><?php echo date('d/m/Y', strtotime($data['tanggal'])); ?></td>
                                    <td>
                                        <?php echo $data['siswa_nama']; ?>
                                        <br><small class="text-muted">NIS: <?php echo $data['nis']; ?></small>
                                    </td>
                                    <td><?php echo $data['kelas']; ?></td>
                                    <td><?php echo htmlspecialchars($data['jenis_pelanggaran']); ?></td>
                                    <td><?php echo htmlspecialchars($data['keterangan']); ?></td>
                                    <td class="text-center">
                                        <span class="badge <?php echo $data['poin'] >= 10 ? 'badge-danger' : 'badge-warning'; ?>">
                                            <?php echo $data['poin']; ?> Poin
                                        </span>
                                    </td>
                                    <td>
                                        <?php echo $data['guru_nama'] ?: 'System'; ?>
                                        <?php if ($data['wali_nama']): ?>
                                            <br><small class="text-muted">Wali: <?php echo $data['wali_nama']; ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge <?php echo $data['status'] === 'Selesai' ? 'badge-success' : 'badge-warning'; ?>">
                                            <?php echo $data['status']; ?>
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-info btn-sm" 
                                                onclick="viewDetails(<?php echo $data['id']; ?>)"
                                                title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function viewDetails(id) {
            // Implementasi view detail
            alert('Detail pelanggaran ID: ' + id);
        }
    </script>
</body>
</html>