<?php
session_start();
if (!isset($_SESSION['username']) || !in_array($_SESSION['role'], ['admin', 'guru'])) {
    header("Location: index.php");
    exit;
}

include "config.php";
date_default_timezone_set("Asia/Jakarta");

if (isset($_GET['nisn'])) {
  $nisn = $_GET['nisn'];
  $tanggal = date("Y-m-d");
  $jam = date("H:i:s");

  // cek hari libur
  $cekLibur = mysqli_query($conn, "SELECT * FROM hari_libur WHERE tanggal='$tanggal'");
  if (mysqli_num_rows($cekLibur) > 0) {
    echo "⛔ Hari ini libur!";
    exit;
  }

  // cek siswa
  $siswa = mysqli_query($conn, "SELECT * FROM siswa WHERE nisn='$nisn'");
  if (mysqli_num_rows($siswa) == 0) {
    echo "❌ Siswa tidak ditemukan.";
    exit;
  }
  $s = mysqli_fetch_assoc($siswa);

  // cek absensi hari ini
  $cekAbsen = mysqli_query($conn, "SELECT * FROM absensi WHERE siswa_id={$s['id']} AND tanggal='$tanggal'");
  if (mysqli_num_rows($cekAbsen) == 0) {
    // absen masuk
    mysqli_query($conn, "INSERT INTO absensi (siswa_id, tanggal, jam, status) 
                         VALUES ({$s['id']}, '$tanggal', '$jam', 'H')");
    echo "✅ Absen masuk: {$s['nama']} ({$s['kelas']})<br>🕒 Jam hadir: $jam";
  } else {
    $row = mysqli_fetch_assoc($cekAbsen);

    if (empty($row['jam_pulang'])) {
      // hitung selisih menit
      $jamMasuk = strtotime($row['jam']);
      $jamSekarang = strtotime($jam);
      $selisihMenit = ($jamSekarang - $jamMasuk) / 60;

      if ($selisihMenit >= 120) { // minimal 2 jam
        mysqli_query($conn, "UPDATE absensi SET jam_pulang='$jam' WHERE id={$row['id']}");
        echo "✅ Absen pulang: {$s['nama']} ({$s['kelas']})<br>🕒 Jam hadir: {$row['jam']}<br>🕒 Jam pulang: $jam";
      } else {
        $sisa = 120 - round($selisihMenit);
        echo "⛔ Belum bisa absen pulang. Minimal 2 jam setelah hadir.<br>
              🕒 Jam hadir: {$row['jam']}<br>🕒 Sekarang: $jam<br>⏳ Tunggu lagi sekitar $sisa menit.";
      }
    } else {
      echo "ℹ️ {$s['nama']} sudah absen pulang.<br>🕒 Jam hadir: {$row['jam']}<br>🕒 Jam pulang: {$row['jam_pulang']}";
    }
  }
  exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Scan QR Siswa</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://unpkg.com/html5-qrcode"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="container mt-4">
  <h2>Scan QR Code Siswa</h2>
  <a href="dashboard.php" class="btn btn-secondary mb-3">← Kembali</a>

  <!-- area kamera -->
  <div id="reader" style="width: 100%"></div>
  <div id="result" class="mt-3" style="max-height: 300px; overflow-y: auto;"></div>

  <!-- suara beep -->
  <audio id="beepSound" src="beep.mp3" preload="auto"></audio>

  <script>
    function onScanSuccess(qrMessage) {
      fetch("scan.php?nisn=" + encodeURIComponent(qrMessage))
        .then(res => res.text())
        .then(data => {
          let result = document.getElementById("result");
          let alertDiv = document.createElement("div");
          alertDiv.className = "alert alert-info mb-2";
          alertDiv.innerHTML = data;
          result.appendChild(alertDiv);

          // bunyikan beep
          document.getElementById("beepSound").play();

          // auto scroll ke bawah
          result.scrollTop = result.scrollHeight;
        });
    }

    let html5QrcodeScanner = new Html5QrcodeScanner(
      "reader",
      { fps: 10, qrbox: 250 },
      false
    );
    html5QrcodeScanner.render(onScanSuccess);
  </script>
</body>
</html>
