<?php
session_start();
if (!isset($_SESSION['username']) || !in_array($_SESSION['role'], ['admin', 'guru'])) {
    header("Location: index.php");
    exit;
}

include 'config.php';
require 'vendor/phpqrcode/qrlib.php';

// Proses simpan (tambah baru)
if (isset($_POST['simpan'])) {
    $nis   = trim($_POST['nis']);
    $nisn  = trim($_POST['nisn']);
    $nama  = trim($_POST['nama']);
    $kelas = trim($_POST['kelas']);
    $no_wa = trim($_POST['no_wa']);

    // Validasi NIS minimal 1 digit, maksimal 20 digit
    if (empty($nis)) {
        $error = "NIS harus diisi";
    } 
    elseif (!preg_match('/^[0-9]{1,20}$/', $nis)) {
        $error = "NIS harus berupa angka (maksimal 20 digit)";
    }
    // Validasi NISN 10 digit
    elseif (!preg_match('/^[0-9]{10}$/', $nisn)) {
        $error = "NISN harus 10 digit angka";
    }
    // Validasi nama tidak boleh kosong
    elseif (empty($nama)) {
        $error = "Nama harus diisi";
    }
    // Validasi kelas tidak boleh kosong
    elseif (empty($kelas)) {
        $error = "Kelas harus diisi";
    }
    // Validasi kelas maksimal 10 karakter
    elseif (strlen($kelas) > 10) {
        $error = "Kelas maksimal 10 karakter";
    }
    // Validasi nomor WA (opsional, tapi jika diisi harus valid)
    elseif (!empty($no_wa) && !preg_match('/^[0-9]{10,15}$/', $no_wa)) {
        $error = "Nomor WhatsApp harus berupa angka (10-15 digit)";
    }
    // Cek duplikasi NIS
    elseif (mysqli_num_rows(mysqli_query($conn, "SELECT id FROM siswa WHERE nis='$nis' AND status='aktif'")) > 0) {
        $error = "NIS sudah digunakan oleh siswa lain";
    }
    // Cek duplikasi NISN
    elseif (mysqli_num_rows(mysqli_query($conn, "SELECT id FROM siswa WHERE nisn='$nisn' AND status='aktif'")) > 0) {
        $error = "NISN sudah digunakan oleh siswa lain";
    }
    else {
        // Format nomor WA jika dimulai dengan 0
        if (!empty($no_wa) && $no_wa[0] == '0') {
            $no_wa = '62' . substr($no_wa, 1);
        }

        mysqli_query($conn, "INSERT INTO siswa (nis, nisn, nama, kelas, no_wa, status) 
                             VALUES ('$nis', '$nisn', '$nama', '$kelas', '$no_wa', 'aktif')");

        // Buat akun user untuk siswa
        $username = $nisn;
        $password = md5($nisn);
        $role     = 'siswa';

        $cek_user = mysqli_query($conn, "SELECT id FROM users WHERE username='$username' LIMIT 1");
        if (mysqli_num_rows($cek_user) == 0) {
            mysqli_query($conn, "INSERT INTO users (username, nama, password, role) 
                                 VALUES ('$username', '$nama', '$password', '$role')");
        }

        // Generate QR Code
        $qr_dir = "assets/qr/";
        if (!is_dir($qr_dir)) mkdir($qr_dir, 0777, true);
        QRcode::png($nisn, $qr_dir . "$nisn.png", QR_ECLEVEL_L, 4);

        $_SESSION['success'] = "Data siswa berhasil ditambahkan!";
        header("Location: siswa.php");
        exit;
    }
}

// Proses update data (edit)
if (isset($_POST['update'])) {
    $id    = intval($_POST['id']);
    $nis   = trim($_POST['nis']);
    $nisn  = trim($_POST['nisn']);
    $nama  = trim($_POST['nama']);
    $kelas = trim($_POST['kelas']);
    $no_wa = trim($_POST['no_wa']);

    // Validasi NIS minimal 1 digit, maksimal 20 digit
    if (empty($nis)) {
        $error = "NIS harus diisi";
    } 
    elseif (!preg_match('/^[0-9]{1,20}$/', $nis)) {
        $error = "NIS harus berupa angka (maksimal 20 digit)";
    }
    // Validasi NISN 10 digit
    elseif (!preg_match('/^[0-9]{10}$/', $nisn)) {
        $error = "NISN harus 10 digit angka";
    }
    // Validasi nama tidak boleh kosong
    elseif (empty($nama)) {
        $error = "Nama harus diisi";
    }
    // Validasi kelas tidak boleh kosong
    elseif (empty($kelas)) {
        $error = "Kelas harus diisi";
    }
    // Validasi kelas maksimal 10 karakter
    elseif (strlen($kelas) > 10) {
        $error = "Kelas maksimal 10 karakter";
    }
    // Validasi nomor WA (opsional, tapi jika diisi harus valid)
    elseif (!empty($no_wa) && !preg_match('/^[0-9]{10,15}$/', $no_wa)) {
        $error = "Nomor WhatsApp harus berupa angka (10-15 digit)";
    }
    // Cek duplikasi NIS (kecuali untuk data yang sedang diedit)
    elseif (mysqli_num_rows(mysqli_query($conn, "SELECT id FROM siswa WHERE nis='$nis' AND id != $id AND status='aktif'")) > 0) {
        $error = "NIS sudah digunakan oleh siswa lain";
    }
    // Cek duplikasi NISN (kecuali untuk data yang sedang diedit)
    elseif (mysqli_num_rows(mysqli_query($conn, "SELECT id FROM siswa WHERE nisn='$nisn' AND id != $id AND status='aktif'")) > 0) {
        $error = "NISN sudah digunakan oleh siswa lain";
    }
    else {
        // Format nomor WA jika dimulai dengan 0
        if (!empty($no_wa) && $no_wa[0] == '0') {
            $no_wa = '62' . substr($no_wa, 1);
        }

        $res_old = mysqli_query($conn, "SELECT nisn FROM siswa WHERE id=$id LIMIT 1");
        $old     = mysqli_fetch_assoc($res_old);
        $old_nisn = $old['nisn'];

        mysqli_query($conn, "UPDATE siswa 
                             SET nis='$nis', nisn='$nisn', nama='$nama', kelas='$kelas', no_wa='$no_wa' 
                             WHERE id=$id");

        mysqli_query($conn, "UPDATE users 
                             SET username='$nisn', nama='$nama', password=md5('$nisn') 
                             WHERE username='$old_nisn' AND role='siswa'");

        $qr_dir = "assets/qr/";
        if (!is_dir($qr_dir)) mkdir($qr_dir, 0777, true);
        
        // Hapus QR code lama dan buat yang baru
        if (file_exists($qr_dir . "$old_nisn.png")) {
            unlink($qr_dir . "$old_nisn.png");
        }
        QRcode::png($nisn, $qr_dir . "$nisn.png", QR_ECLEVEL_L, 4);

        $_SESSION['success'] = "Data siswa berhasil diupdate!";
        header("Location: siswa.php");
        exit;
    }
}

// Tandai siswa keluar
if (isset($_GET['keluar'])) {
    $id = intval($_GET['keluar']);
    $res = mysqli_query($conn, "SELECT nisn FROM siswa WHERE id=$id LIMIT 1");
    $data = mysqli_fetch_assoc($res);
    $nisn_keluar = $data['nisn'];

    mysqli_query($conn, "UPDATE siswa SET status='keluar' WHERE id=$id");
    mysqli_query($conn, "DELETE FROM users WHERE username='$nisn_keluar' AND role='siswa'");

    $_SESSION['success'] = "Siswa berhasil ditandai keluar!";
    header("Location: siswa.php");
    exit;
}

// Generate akun massal
if (isset($_POST['generate_akun'])) {
    $q_siswa = mysqli_query($conn, "SELECT nisn, nama FROM siswa WHERE status='aktif'");
    $count = 0;
    while ($s = mysqli_fetch_assoc($q_siswa)) {
        $username = $s['nisn'];
        $nama     = $s['nama'];
        $password = md5($s['nisn']);
        $role     = 'siswa';

        $cek = mysqli_query($conn, "SELECT id FROM users WHERE username='$username' LIMIT 1");
        if (mysqli_num_rows($cek) == 0) {
            mysqli_query($conn, "INSERT INTO users (username, nama, password, role) 
                                 VALUES ('$username', '$nama', '$password', '$role')");
            $count++;
        }
    }
    $_SESSION['success'] = "Generate akun selesai. $count akun baru dibuat.";
    header("Location: siswa.php");
    exit;
}

// Ambil data untuk edit jika ada
$edit_data = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $res = mysqli_query($conn, "SELECT * FROM siswa WHERE id=$id LIMIT 1");
    $edit_data = mysqli_fetch_assoc($res);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Data Siswa</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .form-control:invalid {
        border-color: #dc3545;
    }
    .form-control:valid {
        border-color: #198754;
    }
    .input-hint {
        font-size: 0.875rem;
        margin-top: 0.25rem;
    }
    .btn-action {
        margin: 2px;
    }
  </style>
</head>
<body class="container py-4">

  <h2 class="text-center mb-4">Data Siswa</h2>

  <a href="dashboard.php" class="btn btn-secondary mb-3">← Kembali ke Dashboard</a>

  <?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="fas fa-check-circle"></i> <?= $_SESSION['success'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    <?php unset($_SESSION['success']); ?>
  <?php endif; ?>

  <?php if (isset($error)): ?>
    <div class="alert alert-danger"><?= $error ?></div>
  <?php endif; ?>

  <!-- Form Input / Edit -->
  <div class="card mb-4">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">
            <i class="fas fa-<?= $edit_data ? 'edit' : 'plus' ?>"></i>
            <?= $edit_data ? 'Edit Data Siswa' : 'Tambah Data Siswa Baru' ?>
        </h5>
    </div>
    <div class="card-body">
        <form method="post" class="row g-3">
            <input type="hidden" name="id" value="<?= $edit_data['id'] ?? '' ?>">
            
            <div class="col-md-2">
                <label for="nis" class="form-label">NIS *</label>
                <input type="text" name="nis" class="form-control" placeholder="Contoh: 1234567" required 
                       value="<?= $edit_data['nis'] ?? '' ?>" pattern="[0-9]{1,20}" 
                       title="NIS harus berupa angka (1-20 digit)">
                <div class="input-hint text-muted">1-20 digit angka</div>
            </div>
            
            <div class="col-md-2">
                <label for="nisn" class="form-label">NISN *</label>
                <input type="text" name="nisn" class="form-control" placeholder="Contoh: 1234567890" required 
                       value="<?= $edit_data['nisn'] ?? '' ?>" pattern="[0-9]{10}" 
                       title="NISN harus 10 digit angka">
                <div class="input-hint text-muted">10 digit angka</div>
            </div>
            
            <div class="col-md-3">
                <label for="nama" class="form-label">Nama Lengkap *</label>
                <input type="text" name="nama" class="form-control" placeholder="Nama lengkap siswa" required 
                       value="<?= $edit_data['nama'] ?? '' ?>">
            </div>
            
            <div class="col-md-2">
                <label for="kelas" class="form-label">Kelas *</label>
                <input type="text" name="kelas" class="form-control" placeholder="Contoh: 7A" required 
                       value="<?= $edit_data['kelas'] ?? '' ?>" maxlength="10"
                       title="Kelas maksimal 10 karakter">
                <div class="input-hint text-muted">Maks. 10 karakter</div>
            </div>
            
            <div class="col-md-2">
                <label for="no_wa" class="form-label">Nomor WhatsApp</label>
                <input type="text" name="no_wa" class="form-control" placeholder="6285xxxx" 
                       value="<?= $edit_data['no_wa'] ?? '' ?>" pattern="[0-9]{10,15}"
                       title="Nomor WhatsApp 10-15 digit">
                <div class="input-hint text-muted">Opsional</div>
            </div>
            
            <div class="col-md-1 d-flex align-items-end">
                <?php if ($edit_data): ?>
                    <button type="submit" name="update" class="btn btn-warning w-100">
                        <i class="fas fa-save"></i> Update
                    </button>
                <?php else: ?>
                    <button type="submit" name="simpan" class="btn btn-success w-100">
                        <i class="fas fa-save"></i> Simpan
                    </button>
                <?php endif; ?>
            </div>
            
            <?php if ($edit_data): ?>
            <div class="col-md-1 d-flex align-items-end">
                <a href="siswa.php" class="btn btn-secondary w-100">
                    <i class="fas fa-times"></i> Batal
                </a>
            </div>
            <?php endif; ?>
        </form>
    </div>
  </div>

  <!-- Action Buttons -->
  <div class="row mb-3">
    <div class="col-md-12">
        <form method="post" class="d-inline">
            <button type="submit" name="generate_akun" class="btn btn-dark">
                <i class="fas fa-bolt"></i> Generate Akun Siswa
            </button>
        </form>
        <a href="cetak_kartu.php" class="btn btn-success" target="_blank">
            <i class="fas fa-print"></i> Cetak Semua Kartu QR
        </a>
        <a href="siswa_keluar.php" class="btn btn-outline-danger">
            <i class="fas fa-history"></i> Lihat Siswa Keluar
        </a>
        <a href="import_siswa.php" class="btn btn-info">
            <i class="fas fa-download"></i> Import dari Excel
        </a>
    </div>
  </div>

  <!-- Tabel Data Siswa -->
  <div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">
            <i class="fas fa-list"></i> Daftar Siswa Aktif
            <span class="badge bg-primary"><?= mysqli_num_rows(mysqli_query($conn, "SELECT id FROM siswa WHERE status='aktif'")) ?> Siswa</span>
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover mb-0">
                <thead class="table-primary">
                    <tr class="text-center">
                        <th width="5%">No</th>
                        <th width="10%">NIS</th>
                        <th width="15%">NISN</th>
                        <th width="20%">Nama</th>
                        <th width="10%">Kelas</th>
                        <th width="15%">No. WhatsApp</th>
                        <th width="10%">QR Code</th>
                        <th width="15%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $q = mysqli_query($conn, "SELECT * FROM siswa WHERE status='aktif' ORDER BY kelas, nama ASC");
                    $no = 1;
                    if (mysqli_num_rows($q) == 0): ?>
                        <tr>
                            <td colspan="8" class="text-center py-4 text-muted">
                                <i class="fas fa-users fa-2x mb-2"></i><br>
                                Belum ada data siswa
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php while ($row = mysqli_fetch_assoc($q)): ?>
                            <tr>
                                <td class="text-center"><?= $no++ ?></td>
                                <td class="text-center"><?= $row['nis'] ?></td>
                                <td><?= $row['nisn'] ?></td>
                                <td><?= htmlspecialchars($row['nama']) ?></td>
                                <td class="text-center"><?= $row['kelas'] ?></td>
                                <td><?= $row['no_wa'] ?: '<span class="text-muted">-</span>' ?></td>
                                <td class="text-center">
                                    <?php if (file_exists("assets/qr/{$row['nisn']}.png")): ?>
                                        <a href="assets/qr/<?= $row['nisn'] ?>.png" target="_blank" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-qrcode"></i> Lihat QR
                                        </a>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">QR Belum Ada</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <a href="siswa.php?edit=<?= $row['id'] ?>" class="btn btn-sm btn-info btn-action" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="siswa.php?keluar=<?= $row['id'] ?>" class="btn btn-sm btn-warning btn-action" 
                                       onclick="return confirm('Yakin menandai <?= htmlspecialchars($row['nama']) ?> sebagai keluar?')" title="Tandai Keluar">
                                        <i class="fas fa-sign-out-alt"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/js/all.min.js"></script>
  <script>
    // Real-time validation
    document.addEventListener('DOMContentLoaded', function() {
        const forms = document.querySelectorAll('form');
        forms.forEach(form => {
            const inputs = form.querySelectorAll('input[pattern]');
            inputs.forEach(input => {
                input.addEventListener('input', function() {
                    if (this.validity.valid) {
                        this.classList.remove('is-invalid');
                        this.classList.add('is-valid');
                    } else {
                        this.classList.remove('is-valid');
                        this.classList.add('is-invalid');
                    }
                });
            });
        });
    });
  </script>
</body>
</html>