<?php
include "config.php";
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['username']) || !in_array($_SESSION['role'], ['admin', 'guru'])) {
    echo json_encode(["status" => "error", "message" => "Unauthorized"]);
    exit;
}

// Fungsi kirimWA yang sama seperti di atas
function kirimWA($conn, $no_wa, $pesan) {
    // ... (salin fungsi kirimWA yang sudah diperbaiki di atas) ...
}

// Test untuk siswa tertentu
if (isset($_GET['nisn'])) {
    $nisn = mysqli_real_escape_string($conn, $_GET['nisn']);
    $sql = "SELECT nama, kelas, no_wa FROM siswa WHERE nisn='$nisn' AND status='aktif' LIMIT 1";
    $res = mysqli_query($conn, $sql);
    
    if ($res && mysqli_num_rows($res) > 0) {
        $siswa = mysqli_fetch_assoc($res);
        $pesan = "TEST: Halo, Orang tua/wali dari {$siswa['nama']}.\n\nAnanda ({$siswa['kelas']}) telah HADIR pada " . date("d-m-Y H:i");
        
        $result = kirimWA($conn, $siswa['no_wa'], $pesan);
        echo json_encode(["status" => "success", "message" => "Test WA untuk {$siswa['nama']}: $result"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Siswa tidak ditemukan"]);
    }
    exit;
}

// Test nomor manual
if (isset($_GET['phone'])) {
    $phone = mysqli_real_escape_string($conn, $_GET['phone']);
    $pesan = "TEST: Ini adalah pesan test notifikasi WhatsApp dari sistem absensi sekolah. " . date("d-m-Y H:i");
    
    $result = kirimWA($conn, $phone, $pesan);
    echo json_encode(["status" => "success", "message" => "Test WA untuk $phone: $result"]);
    exit;
}

echo json_encode(["status" => "error", "message" => "Parameter tidak valid"]);
?>