<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Kandidat_model extends CI_Model
{

    public $table = 'kandidat';
    public $id = 'idkandidat';
    public $order = 'DESC';

    function __construct()
    {
        parent::__construct();
    }

    // get all
    function get_all()
    {
        $this->db->order_by($this->id, $this->order);
        return $this->db->get($this->table)->result();
    }

    // get data by id
    function get_by_id($id)
    {
        $this->db->where($this->id, $id);
        return $this->db->get($this->table)->row();
    }

    // get total rows
    function total_rows($q = NULL)
    {
        $this->db->like('idkandidat', $q);
        $this->db->or_like('organisasi', $q);
        $this->db->or_like('nama', $q);
        $this->db->or_like('nourut', $q);
        $this->db->or_like('jumlahsuara', $q);
        $this->db->or_like('visi', $q);
        $this->db->or_like('misi', $q);
        $this->db->or_like('foto', $q);
        $this->db->or_like('status', $q);
        $this->db->from($this->table);
        return $this->db->count_all_results();
    }

    // get data with limit and search
    function get_limit_data($limit, $start = 0, $q = NULL)
    {
        $this->db->order_by($this->id, $this->order);
        $this->db->like('idkandidat', $q);
        $this->db->or_like('organisasi', $q);
        $this->db->or_like('nama', $q);
        $this->db->or_like('nourut', $q);
        $this->db->or_like('jumlahsuara', $q);
        $this->db->or_like('visi', $q);
        $this->db->or_like('misi', $q);
        $this->db->or_like('foto', $q);
        $this->db->or_like('status', $q);
        $this->db->limit($limit, $start);
        return $this->db->get($this->table)->result();
    }

    // insert data
    function insert($data)
    {
        $this->db->insert($this->table, $data);
    }

    // update data
    function update($id, $data)
    {
        $this->db->where($this->id, $id);
        $this->db->update($this->table, $data);
    }

    // delete data
    function delete($id)
    {
        $this->db->where($this->id, $id);
        $this->db->delete($this->table);
    }

    function get_kandidat_osis()
    {
        $this->db->order_by('nourut', 'ASC');
        $this->db->where('organisasi', 'OSIS');        
        return $this->db->get($this->table)->result();
    }

    function get_kandidat_mpk()
    {
        $this->db->order_by('nourut', 'ASC');
        $this->db->where('organisasi', 'MPK');
        return $this->db->get($this->table)->result();
    }

    function reset_jumlah_suara()
    {
        $this->db->set('jumlahsuara', 0);
        $this->db->update($this->table);
    }
}

/* End of file Kandidat_model.php */
/* Location: ./application/models/Kandidat_model.php */
/* Please DO NOT modify this information : */
/* Generated by Harviacode Codeigniter CRUD Generator 2019-10-06 02:46:27 */
/* http://harviacode.com */
